/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.headers;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class Header
extends BaseExtensibleModel<org.eclipse.microprofile.openapi.models.headers.Header>
implements org.eclipse.microprofile.openapi.models.headers.Header {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    protected org.eclipse.microprofile.openapi.models.headers.Header filter(OASFilter filter) {
        return filter.filterHeader((org.eclipse.microprofile.openapi.models.headers.Header)this);
    }

    public Boolean getRequired() {
        return (Boolean)this.getProperty("required", Boolean.class);
    }

    public void setRequired(Boolean newValue) {
        this.setProperty("required", newValue);
    }

    public Boolean getDeprecated() {
        return (Boolean)this.getProperty("deprecated", Boolean.class);
    }

    public void setDeprecated(Boolean newValue) {
        this.setProperty("deprecated", newValue);
    }

    public Boolean getAllowEmptyValue() {
        return (Boolean)this.getProperty("allowEmptyValue", Boolean.class);
    }

    public void setAllowEmptyValue(Boolean newValue) {
        this.setProperty("allowEmptyValue", newValue);
    }

    public Header.Style getStyle() {
        return (Header.Style)this.getProperty("style", Header.Style.class);
    }

    public void setStyle(Header.Style newValue) {
        this.setProperty("style", newValue);
    }

    public Boolean getExplode() {
        return (Boolean)this.getProperty("explode", Boolean.class);
    }

    public void setExplode(Boolean newValue) {
        this.setProperty("explode", newValue);
    }

    public Schema getSchema() {
        return (Schema)this.getProperty("schema", Schema.class);
    }

    public void setSchema(Schema newValue) {
        this.setProperty("schema", newValue);
    }

    public Object getExample() {
        return this.getProperty("example", Object.class);
    }

    public void setExample(Object newValue) {
        this.setProperty("example", newValue);
    }

    public Map<String, Example> getExamples() {
        return this.getMapProperty("examples");
    }

    public void setExamples(Map<String, Example> newValue) {
        this.setMapProperty("examples", newValue);
    }

    public Header addExample(String newKey, Example newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("examples", newKey, newValue);
        return this;
    }

    public void removeExample(String key) {
        this.removeMapPropertyEntry("examples", key);
    }

    public Content getContent() {
        return (Content)this.getProperty("content", Content.class);
    }

    public void setContent(Content newValue) {
        this.setProperty("content", newValue);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(11);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(11);

        public Properties() {
            this.types.put("ref", DataType.type(String.class));
            this.minVersions.put("ref", OpenApiVersion.V3_0);
            this.types.put("description", DataType.type(String.class));
            this.minVersions.put("description", OpenApiVersion.V3_0);
            this.types.put("required", DataType.type(Boolean.class));
            this.minVersions.put("required", OpenApiVersion.V3_0);
            this.types.put("deprecated", DataType.type(Boolean.class));
            this.minVersions.put("deprecated", OpenApiVersion.V3_0);
            this.types.put("allowEmptyValue", DataType.type(Boolean.class));
            this.minVersions.put("allowEmptyValue", OpenApiVersion.V3_0);
            this.types.put("style", DataType.type(Header.Style.class));
            this.minVersions.put("style", OpenApiVersion.V3_0);
            this.types.put("explode", DataType.type(Boolean.class));
            this.minVersions.put("explode", OpenApiVersion.V3_0);
            this.types.put("schema", DataType.type(Schema.class));
            this.minVersions.put("schema", OpenApiVersion.V3_0);
            this.types.put("example", DataType.type(Object.class));
            this.minVersions.put("example", OpenApiVersion.V3_0);
            this.types.put("examples", DataType.mapOf((DataType)DataType.type(Example.class)));
            this.minVersions.put("examples", OpenApiVersion.V3_0);
            this.types.put("content", DataType.type(Content.class));
            this.minVersions.put("content", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

