/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import org.jboss.tm.TransactionManagerLocator;

public class TxUtils {
    private static final String ARJUNA_REAPER_THREAD_NAME = "Transaction Reaper Worker";
    private static final String[] TxStatusStrings = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};

    private TxUtils() {
    }

    public static boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return TxUtils.isActive(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isActive(TransactionManager tm) {
        try {
            return TxUtils.isActive(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isActive() {
        return TxUtils.isActive(TransactionManagerLocator.locateTransactionManager());
    }

    public static boolean isActive(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TxUtils.isActive(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isActive(int status) {
        return status == 0;
    }

    public static boolean isUncommitted(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return TxUtils.isUncommitted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isUncommitted(TransactionManager tm) {
        try {
            return TxUtils.isUncommitted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isUncommitted() {
        return TxUtils.isUncommitted(TransactionManagerLocator.locateTransactionManager());
    }

    public static boolean isUncommitted(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TxUtils.isUncommitted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isUncommitted(int status) {
        return status == 0 || status == 1;
    }

    public static boolean isCompleted(Transaction tx) {
        if (tx == null) {
            return true;
        }
        try {
            int status = tx.getStatus();
            return TxUtils.isCompleted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isCompleted(TransactionManager tm) {
        try {
            return TxUtils.isCompleted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isCompleted() {
        return TxUtils.isCompleted(TransactionManagerLocator.locateTransactionManager());
    }

    public static boolean isCompleted(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TxUtils.isCompleted(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isCompleted(int status) {
        return status == 3 || status == 4 || status == 6;
    }

    public static boolean isRollback(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return TxUtils.isRollback(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isRollback(TransactionManager tm) {
        try {
            return TxUtils.isRollback(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isRollback() {
        return TxUtils.isRollback(TransactionManagerLocator.locateTransactionManager());
    }

    public static boolean isRollback(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return TxUtils.isRollback(status);
        }
        catch (SystemException error) {
            throw new RuntimeException(error);
        }
    }

    public static boolean isRollback(int status) {
        return status == 1 || status == 9 || status == 4;
    }

    public static String getStatusAsString(int status) {
        if (status >= 0 && status <= 9) {
            return TxStatusStrings[status];
        }
        return "STATUS_INVALID(" + status + ")";
    }

    public static String getXAResourceFlagsAsString(int flags) {
        if (flags == 0) {
            return "|TMNOFLAGS";
        }
        StringBuffer sbuf = new StringBuffer(64);
        if ((flags & 0x40000000) != 0) {
            sbuf.append("|TMONEPHASE");
        }
        if ((flags & 0x200000) != 0) {
            sbuf.append("|TMJOIN");
        }
        if ((flags & 0x8000000) != 0) {
            sbuf.append("|TMRESUME");
        }
        if ((flags & 0x4000000) != 0) {
            sbuf.append("|TMSUCCESS");
        }
        if ((flags & 0x20000000) != 0) {
            sbuf.append("|TMFAIL");
        }
        if ((flags & 0x2000000) != 0) {
            sbuf.append("|TMSUSPEND");
        }
        if ((flags & 0x1000000) != 0) {
            sbuf.append("|TMSTARTRSCAN");
        }
        if ((flags & 0x800000) != 0) {
            sbuf.append("|TMENDRSCAN");
        }
        return sbuf.toString();
    }

    public static String getXAErrorCodeAsString(int errorCode) {
        switch (errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "XA_UNKNOWN(" + errorCode + ")";
    }

    public static boolean isTransactionManagerTimeoutThread() {
        String currentThreadName = Thread.currentThread().getName();
        return currentThreadName != null && currentThreadName.startsWith(ARJUNA_REAPER_THREAD_NAME);
    }
}

