/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.utils;

import org.aesh.terminal.utils.OSUtils;

public class Config {
    private static final boolean macOS = System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").startsWith("darwin");
    private static final boolean windows = System.getProperty("os.name").startsWith("Windows");
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String pathSeparator = System.getProperty("file.separator");
    private static final String tmpDir = System.getProperty("java.io.tmpdir");
    private static final boolean posixCompatible = Config.checkPosixCompability();
    public static final int[] CR = lineSeparator.codePoints().toArray();
    private static boolean cygwin = OSUtils.IS_CYGWIN;

    public static boolean isOSPOSIXCompatible() {
        return posixCompatible;
    }

    public static boolean isCygwin() {
        return cygwin;
    }

    public static boolean isMacOS() {
        return macOS;
    }

    public static boolean isWindows() {
        return windows;
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getPathSeparator() {
        return pathSeparator;
    }

    public static String getTmpDir() {
        return tmpDir;
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    private static boolean checkPosixCompability() {
        if (Config.isWindows()) {
            return OSUtils.IS_CYGWIN;
        }
        return !System.getProperty("os.name").startsWith("OS/2");
    }
}

