/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.BeanTypeAssignabilityRules;
import io.quarkus.arc.impl.CovariantTypes;
import io.quarkus.arc.impl.Types;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

final class DelegateInjectionPointAssignabilityRules
extends BeanTypeAssignabilityRules {
    private static final DelegateInjectionPointAssignabilityRules INSTANCE = new DelegateInjectionPointAssignabilityRules();

    private DelegateInjectionPointAssignabilityRules() {
    }

    public static DelegateInjectionPointAssignabilityRules instance() {
        return INSTANCE;
    }

    @Override
    protected boolean parametersMatch(Type delegateParameter, Type beanParameter) {
        if (Types.isActualType(delegateParameter) && Types.isActualType(beanParameter)) {
            return this.matches(delegateParameter, beanParameter);
        }
        if (delegateParameter instanceof WildcardType && Types.isActualType(beanParameter)) {
            return this.parametersMatch((Type)((WildcardType)delegateParameter), beanParameter);
        }
        if (delegateParameter instanceof WildcardType && beanParameter instanceof TypeVariable) {
            return this.parametersMatch((WildcardType)delegateParameter, (TypeVariable)beanParameter);
        }
        if (delegateParameter instanceof TypeVariable && beanParameter instanceof TypeVariable) {
            return this.parametersMatch((TypeVariable)delegateParameter, (TypeVariable)beanParameter);
        }
        if (delegateParameter instanceof TypeVariable && Types.isActualType(beanParameter)) {
            return this.parametersMatch((TypeVariable)delegateParameter, beanParameter);
        }
        if (Object.class.equals((Object)delegateParameter) && beanParameter instanceof TypeVariable) {
            TypeVariable beanParameterVariable = (TypeVariable)beanParameter;
            return Object.class.equals((Object)beanParameterVariable.getBounds()[0]);
        }
        return false;
    }

    @Override
    protected boolean parametersMatch(WildcardType delegateParameter, TypeVariable<?> beanParameter) {
        Type[] beanParameterBounds = DelegateInjectionPointAssignabilityRules.getUppermostTypeVariableBounds(beanParameter);
        if (!this.lowerBoundsOfWildcardMatch(beanParameterBounds, delegateParameter)) {
            return false;
        }
        Type[] requiredUpperBounds = delegateParameter.getUpperBounds();
        return this.boundsMatch(requiredUpperBounds, beanParameterBounds);
    }

    @Override
    protected boolean parametersMatch(TypeVariable<?> delegateParameter, TypeVariable<?> beanParameter) {
        return this.boundsMatch(DelegateInjectionPointAssignabilityRules.getUppermostTypeVariableBounds(delegateParameter), DelegateInjectionPointAssignabilityRules.getUppermostTypeVariableBounds(beanParameter));
    }

    protected boolean parametersMatch(TypeVariable<?> delegateParameter, Type beanParameter) {
        for (Type type : DelegateInjectionPointAssignabilityRules.getUppermostTypeVariableBounds(delegateParameter)) {
            if (CovariantTypes.isAssignableFrom(type, beanParameter)) continue;
            return false;
        }
        return true;
    }
}

