/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.session.RevokedTokenPersisterProvider;
import org.keycloak.timer.ScheduledTask;

public class ClearExpiredRevokedTokens
implements ScheduledTask {
    protected static final Logger logger = Logger.getLogger(ClearExpiredRevokedTokens.class);
    public static final String TASK_NAME = "ClearExpiredRevokedTokens";

    public void run(KeycloakSession session) {
        long currentTimeMillis = Time.currentTimeMillis();
        ((RevokedTokenPersisterProvider)session.getProvider(RevokedTokenPersisterProvider.class)).expireTokens();
        long took = Time.currentTimeMillis() - currentTimeMillis;
        logger.debugf("%s finished in %d ms", (Object)this.getTaskName(), (Object)took);
    }

    public String getTaskName() {
        return TASK_NAME;
    }
}

