/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.json.JsonUtils;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;

public final class ValuePatternMatcher {
    private JsonObject pattern;
    private JsonObject value;

    private ValuePatternMatcher(JsonObject pattern, JsonObject value) {
        this.pattern = pattern;
        this.value = value;
    }

    public static final ValuePatternMatcher with(JsonObject pattern, JsonObject value) {
        return new ValuePatternMatcher(pattern, value);
    }

    public boolean match() {
        JsonValue value2 = (JsonValue)this.pattern.getOrDefault((Object)"@value", null);
        JsonValue type2 = (JsonValue)this.pattern.getOrDefault((Object)"@type", null);
        JsonValue lang2 = (JsonValue)this.pattern.getOrDefault((Object)"@language", null);
        return value2 == null && type2 == null && lang2 == null || this.matchValue(value2) && this.matchType(type2) && this.matchLanguage(lang2);
    }

    private boolean matchValue(JsonValue value2) {
        JsonValue value1 = (JsonValue)this.value.getOrDefault((Object)"@value", null);
        return JsonUtils.isNotNull(value1) && ValuePatternMatcher.isWildcard(value2, new String[0]) || JsonUtils.isNotNull(value2) && JsonUtils.toJsonArray(value2).contains((Object)value1);
    }

    private boolean matchType(JsonValue type2) {
        JsonValue type1 = (JsonValue)this.value.getOrDefault((Object)"@type", null);
        return JsonUtils.isNotNull(type1) && ValuePatternMatcher.isWildcard(type2, new String[0]) || JsonUtils.isNull(type1) && ValuePatternMatcher.isNone(type2) || JsonUtils.isNotNull(type2) && JsonUtils.toJsonArray(type2).contains((Object)type1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchLanguage(JsonValue lang2) {
        String lang1;
        String string = lang1 = this.value.containsKey((Object)"@language") ? this.value.getString("@language").toLowerCase() : null;
        if (lang1 != null) {
            if (ValuePatternMatcher.isWildcard(lang2, new String[0])) return true;
        }
        if (lang1 == null) {
            if (ValuePatternMatcher.isNone(lang2)) return true;
        }
        if (lang1 == null) return false;
        if (lang2 == null) return false;
        if (!JsonUtils.isNotNull(lang2)) return false;
        if (!JsonUtils.toStream(lang2).map(JsonString.class::cast).map(JsonString::getString).anyMatch(x -> x.equalsIgnoreCase(lang1))) return false;
        return true;
    }

    protected static final boolean isWildcard(JsonValue value, String ... except) {
        if (JsonUtils.isEmptyObject(value)) {
            return true;
        }
        JsonObject frame = null;
        if (JsonUtils.isObject(value)) {
            frame = (JsonObject)value;
        } else if (JsonUtils.isArray(value) && value.asJsonArray().size() == 1 && JsonUtils.isObject((JsonValue)value.asJsonArray().get(0))) {
            frame = value.asJsonArray().getJsonObject(0);
        }
        return frame != null && (frame.isEmpty() || Arrays.asList("@default", "@omitDefault", "@embed", "@explicit", "@requireAll", except).containsAll(frame.keySet()));
    }

    protected static final boolean isNone(JsonValue value) {
        return JsonUtils.isNull(value) || JsonUtils.isEmptyArray(value);
    }
}

