/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.keycloak.models.RealmModel;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.theme.PropertiesUtil;
import org.keycloak.theme.ResourceLoader;
import org.keycloak.theme.Theme;

public class ClassLoaderTheme
implements Theme {
    private String name;
    private String parentName;
    private String importName;
    private Theme.Type type;
    private ClassLoader classLoader;
    private String templateRoot;
    private String resourceRoot;
    private String messageRoot;
    private Properties properties;

    public ClassLoaderTheme(String name, Theme.Type type, ClassLoader classLoader) throws IOException {
        this.init(name, type, classLoader);
    }

    public void init(String name, Theme.Type type, ClassLoader classLoader) throws IOException {
        this.name = name;
        this.type = type;
        this.classLoader = classLoader;
        String themeRoot = "theme/" + name + "/" + type.toString().toLowerCase() + "/";
        this.templateRoot = themeRoot;
        this.resourceRoot = themeRoot + "resources/";
        this.messageRoot = themeRoot + "messages/";
        this.properties = new Properties();
        URL p = classLoader.getResource(themeRoot + "theme.properties");
        if (p != null) {
            try (InputStream stream = p.openStream();){
                PropertiesUtil.readCharsetAware(this.properties, stream);
            }
            this.parentName = this.properties.getProperty("parent");
            this.importName = this.properties.getProperty("import");
        } else {
            this.parentName = null;
            this.importName = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getImportName() {
        return this.importName;
    }

    public Theme.Type getType() {
        return this.type;
    }

    public URL getTemplate(String name) {
        return this.classLoader.getResource(this.templateRoot + name);
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        return ResourceLoader.getResourceAsStream(this.resourceRoot, path);
    }

    public Properties getMessages(Locale locale) throws IOException {
        return this.getMessages("messages", locale);
    }

    public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
        if (locale == null) {
            return null;
        }
        Properties m = new Properties();
        URL url = this.classLoader.getResource(this.messageRoot + baseBundlename + "_" + String.valueOf(locale) + ".properties");
        if (url != null) {
            try (InputStream stream = url.openStream();){
                PropertiesUtil.readCharsetAware(m, stream);
            }
        }
        return m;
    }

    public Properties getEnhancedMessages(RealmModel realm, Locale locale) throws IOException {
        if (locale == null) {
            return null;
        }
        Map<Locale, Properties> localeMessages = Collections.singletonMap(locale, this.getMessages(locale));
        return LocaleUtil.enhancePropertiesWithRealmLocalizationTexts(realm, locale, localeMessages);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

