/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.ProviderManagerDeployer;

public class ProviderManagerRegistry {
    public static final ProviderManagerRegistry SINGLETON = new ProviderManagerRegistry();
    protected List<ProviderManager> preBoot = Collections.synchronizedList(new LinkedList());
    protected AtomicReference<ProviderManagerDeployer> deployerRef = new AtomicReference();

    public synchronized void setDeployer(ProviderManagerDeployer deployer) {
        this.deployerRef.set(deployer);
    }

    public synchronized void deploy(ProviderManager pm) {
        ProviderManagerDeployer deployer = this.getDeployer();
        if (deployer == null) {
            this.preBoot.add(pm);
        } else {
            deployer.deploy(pm);
        }
    }

    public synchronized void undeploy(ProviderManager pm) {
        this.preBoot.remove(pm);
        ProviderManagerDeployer deployer = this.getDeployer();
        if (deployer != null) {
            deployer.undeploy(pm);
        }
    }

    private ProviderManagerDeployer getDeployer() {
        return this.deployerRef.get();
    }

    public List<ProviderManager> getPreBoot() {
        return this.preBoot;
    }
}

