/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.internal;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.persistence.remote.configuration.global.RemoteContainerConfiguration;
import org.infinispan.persistence.remote.configuration.global.RemoteContainersConfiguration;
import org.infinispan.persistence.remote.global.GlobalRemoteContainers;
import org.infinispan.util.concurrent.BlockingManager;

@Scope(value=Scopes.GLOBAL)
public class GlobalRemoteContainersImpl
implements GlobalRemoteContainers {
    private static final Log log = LogFactory.getLog(GlobalRemoteContainersImpl.class);
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    BlockingManager blockingManager;
    private final Map<String, CompletionStage<RemoteCacheManager>> remoteContainers = new ConcurrentHashMap<String, CompletionStage<RemoteCacheManager>>();

    @Start
    public void start() {
        RemoteContainersConfiguration configuration = (RemoteContainersConfiguration)this.globalConfiguration.module(RemoteContainersConfiguration.class);
        if (configuration != null) {
            for (Map.Entry<String, RemoteContainerConfiguration> e : configuration.configurations().entrySet()) {
                this.remoteContainers.put(e.getKey(), CompletableFutures.completedNull());
            }
        }
    }

    @Stop
    public void stop() {
        this.remoteContainers.values().forEach(c -> c.thenApply(this::stop));
    }

    private Void stop(RemoteCacheManager rcm) {
        if (rcm != null) {
            rcm.stop();
        }
        return null;
    }

    private void remoteCacheManagerShutdown(String name) {
        this.remoteContainers.computeIfPresent(name, (key, prev) -> prev.thenApply(ignore -> null));
    }

    @Override
    public CompletionStage<RemoteCacheManager> cacheContainer(String name, Marshaller marshaller) {
        CompletionStage cs = this.remoteContainers.computeIfPresent(name, (k, cf) -> cf.thenCompose(prev -> {
            if (prev != null && ((RefCountedRemoteCacheManager)((Object)((Object)prev))).incrementReference()) {
                return CompletableFuture.completedFuture(prev);
            }
            return this.createCacheManager(name, marshaller);
        }));
        if (cs == null) {
            return CompletableFuture.failedFuture((Throwable)org.infinispan.persistence.remote.logging.Log.CONFIG.unknownRemoteCacheManagerContainer(name));
        }
        return cs.thenApply(rcm -> {
            Marshaller inUse = rcm.getConfiguration().marshaller();
            if (!inUse.equals((Object)marshaller)) {
                throw org.infinispan.persistence.remote.logging.Log.CONFIG.shouldUseSameMarshallerWithContainer(inUse, marshaller);
            }
            return rcm;
        });
    }

    private CompletionStage<RemoteCacheManager> createCacheManager(String name, Marshaller marshaller) {
        RemoteContainersConfiguration configuration = (RemoteContainersConfiguration)this.globalConfiguration.module(RemoteContainersConfiguration.class);
        if (configuration != null) {
            Object propertiesToUse;
            RemoteContainerConfiguration rcc = configuration.configurations().get(name);
            if (rcc == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No configuration defined for container " + name));
            }
            ConfigurationBuilder builder = !rcc.uri().isEmpty() ? HotRodURI.create((String)rcc.uri()).toConfigurationBuilder() : new ConfigurationBuilder();
            builder.marshaller(marshaller);
            TypedProperties actualProperties = rcc.properties();
            if (!actualProperties.contains("blocking")) {
                propertiesToUse = new Properties();
                ((Properties)propertiesToUse).putAll((Map<?, ?>)actualProperties);
                ((Properties)propertiesToUse).put("blocking", "false");
            } else {
                propertiesToUse = actualProperties;
            }
            builder.withProperties((Properties)propertiesToUse);
            return this.blockingManager.supplyBlocking(() -> new RefCountedRemoteCacheManager(name, builder.build()), (Object)"RemoteContainer-create");
        }
        return CompletableFuture.failedFuture(new IllegalStateException("No remote container configuration defined"));
    }

    private class RefCountedRemoteCacheManager
    extends RemoteCacheManager {
        private final String name;
        private final AtomicInteger references;

        public RefCountedRemoteCacheManager(String name, Configuration configuration) {
            super(configuration);
            this.name = name;
            this.references = new AtomicInteger(1);
        }

        public void stop() {
            if (this.references.decrementAndGet() == 0) {
                super.stop();
                GlobalRemoteContainersImpl.this.remoteCacheManagerShutdown(this.name);
            }
        }

        public boolean incrementReference() {
            int curr = this.references.get();
            while (curr > 0) {
                if (this.references.compareAndSet(curr, curr + 1)) {
                    return true;
                }
                curr = this.references.get();
            }
            log.warnf("Remote cache manager '%s' was shutdown before acquiring, a new one will be created", (Object)this.name);
            return false;
        }
    }
}

