/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.config.SecurityOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

final class SecurityPropertyMappers {
    private SecurityPropertyMappers() {
    }

    public static PropertyMapper<?>[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(SecurityOptions.FIPS_MODE).transformer(SecurityPropertyMappers::resolveFipsMode).paramLabel("mode").build()};
    }

    private static String resolveFipsMode(String value, ConfigSourceInterceptorContext context) {
        if (value == null) {
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.FIPS)) {
                return FipsMode.NON_STRICT.toString();
            }
            return FipsMode.DISABLED.toString();
        }
        return value;
    }
}

