/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import jakarta.annotation.Priority;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.Function;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

@Priority(value=3299)
public class NestedPropertyMappingInterceptor
implements ConfigSourceInterceptor {
    static final ThreadLocal<LinkedHashSet<String>> recursions = new ThreadLocal();

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        return NestedPropertyMappingInterceptor.resolve(arg_0 -> ((ConfigSourceInterceptorContext)context).restart(arg_0), arg_0 -> ((ConfigSourceInterceptorContext)context).proceed(arg_0), name, false);
    }

    public static ConfigValue proceed(ConfigSourceInterceptorContext context, String name) {
        return NestedPropertyMappingInterceptor.resolve(arg_0 -> ((ConfigSourceInterceptorContext)context).proceed(arg_0), arg_0 -> ((ConfigSourceInterceptorContext)context).proceed(arg_0), name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T resolve(Function<String, T> resolver, Function<String, T> nonRecursiveResolver, String name, boolean startNew) {
        LinkedHashSet<String> recursing = recursions.get();
        if (recursing == null && startNew) {
            recursing = new LinkedHashSet();
            recursions.set(recursing);
        }
        if (recursing != null && recursing.add(name)) {
            try {
                T t = resolver.apply(name);
                return t;
            }
            finally {
                recursing.remove(name);
                if (recursing.isEmpty()) {
                    recursions.set(null);
                }
            }
        }
        return nonRecursiveResolver.apply(name);
    }

    public static Optional<String> getResolvingRoot() {
        return Optional.ofNullable(recursions.get()).filter(s -> !s.isEmpty()).map(s -> (String)s.iterator().next());
    }

    public static ConfigValue getValueFromPropertyMappers(ConfigSourceInterceptorContext context, String name) {
        Function<String, ConfigValue> resolver = n -> PropertyMappers.getValue(context, n);
        return NestedPropertyMappingInterceptor.resolve(resolver, resolver, name, true);
    }
}

