/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import java.util.HashMap;
import java.util.Map;

public class ScmInfoProvider {
    private final String valueFromBuildFile;
    private final String valueFromEnvironment;

    public ScmInfoProvider(String valueFromBuildFile) {
        this.valueFromBuildFile = valueFromBuildFile;
        String repo = System.getenv("GITHUB_REPOSITORY");
        if (repo != null) {
            String qualifiedRepo = "https://github.com/" + repo;
            this.valueFromEnvironment = qualifiedRepo.replace("github.com//", "github.com/");
        } else {
            this.valueFromEnvironment = null;
        }
    }

    public Map<String, String> getSourceRepo() {
        HashMap<String, String> info = null;
        if (this.valueFromEnvironment != null) {
            info = new HashMap<String, String>();
            info.put("url", this.valueFromEnvironment);
        } else if (this.valueFromBuildFile != null) {
            info = new HashMap();
            info.put("url", this.valueFromBuildFile);
        }
        return info;
    }

    public String getInconsistencyWarning() {
        if (this.valueFromEnvironment != null && this.valueFromBuildFile != null && !this.valueFromEnvironment.equals(this.valueFromBuildFile)) {
            return "The scm-url coordinates in the build file, " + this.valueFromBuildFile + " did not match the repository configured in the GITHUB_REPOSITORY environment variable, " + this.valueFromEnvironment + ". The value which will be used for the extension metadata is " + this.valueFromEnvironment + ".";
        }
        return null;
    }
}

