/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.resteasy.reactive.jackson.runtime.ResteasyReactiveServerJacksonRecorder;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.JacksonMapperUtil;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class FullyFeaturedServerJacksonMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private final Instance<ObjectMapper> originalMapper;
    private final Providers providers;
    private final LazyValue<ObjectWriter> defaultWriter;
    private final ConcurrentMap<String, ObjectWriter> perMethodWriter = new ConcurrentHashMap<String, ObjectWriter>();
    private final ConcurrentMap<String, ObjectWriter> perTypeWriter = new ConcurrentHashMap<String, ObjectWriter>();
    private final ConcurrentMap<Class<?>, ObjectMapper> contextResolverMap = new ConcurrentHashMap();
    private final ConcurrentMap<ObjectMapper, ObjectWriter> objectWriterMap = new ConcurrentHashMap<ObjectMapper, ObjectWriter>();

    public FullyFeaturedServerJacksonMessageBodyWriter() {
        this.originalMapper = null;
        this.providers = null;
        this.defaultWriter = null;
    }

    @Inject
    public FullyFeaturedServerJacksonMessageBodyWriter(final Instance<ObjectMapper> mapper, Providers providers) {
        this.originalMapper = mapper;
        this.providers = providers;
        this.defaultWriter = new LazyValue((Supplier)new Supplier<ObjectWriter>(){

            @Override
            public ObjectWriter get() {
                return JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)((ObjectMapper)mapper.get()));
            }
        });
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        OutputStream stream = context.getOrCreateOutputStream();
        if (o instanceof String) {
            stream.write(((String)o).getBytes(StandardCharsets.UTF_8));
        } else {
            JavaType rootType;
            ObjectMapper effectiveMapper = this.getEffectiveMapper(o, context);
            ObjectWriter effectiveWriter = this.getEffectiveWriter(effectiveMapper);
            ResteasyReactiveResourceInfo resourceInfo = context.getResteasyReactiveResourceInfo();
            if (resourceInfo != null) {
                Class<?> jsonViewValue;
                ObjectWriter writerFromAnnotation = this.getObjectWriterFromAnnotations(resourceInfo, genericType, effectiveMapper);
                if (writerFromAnnotation != null) {
                    effectiveWriter = writerFromAnnotation;
                }
                if ((jsonViewValue = ResteasyReactiveServerJacksonRecorder.jsonViewForMethod(resourceInfo.getMethodId())) != null) {
                    effectiveWriter = effectiveWriter.withView(jsonViewValue);
                } else {
                    jsonViewValue = ResteasyReactiveServerJacksonRecorder.jsonViewForClass(resourceInfo.getResourceClass());
                    if (jsonViewValue != null) {
                        effectiveWriter = effectiveWriter.withView(jsonViewValue);
                    }
                }
            }
            if (genericType != null && o != null && (rootType = JacksonMapperUtil.getGenericRootType(genericType, effectiveWriter)) != null && rootType.isTypeOrSuperTypeOf(o.getClass())) {
                effectiveWriter = effectiveWriter.forType(rootType);
            }
            effectiveWriter.writeValue(stream, o);
        }
        stream.close();
    }

    private ObjectWriter getObjectWriterFromAnnotations(ResteasyReactiveResourceInfo resourceInfo, Type type, ObjectMapper mapper) {
        String methodId = resourceInfo.getMethodId();
        Class<? extends BiFunction<ObjectMapper, Type, ObjectWriter>> customSerializationValue = ResteasyReactiveServerJacksonRecorder.customSerializationForMethod(methodId);
        if (customSerializationValue != null) {
            return this.perMethodWriter.computeIfAbsent(methodId, new MethodObjectWriterFunction(customSerializationValue, type, mapper));
        }
        customSerializationValue = ResteasyReactiveServerJacksonRecorder.customSerializationForClass(resourceInfo.getResourceClass());
        if (customSerializationValue != null) {
            Type effectiveType = type;
            if (type instanceof ParameterizedType) {
                effectiveType = ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return this.perTypeWriter.computeIfAbsent(effectiveType.getTypeName(), new MethodObjectWriterFunction(customSerializationValue, type, mapper));
        }
        return null;
    }

    private ObjectWriter getEffectiveWriter(final ObjectMapper effectiveMapper) {
        if (effectiveMapper == this.originalMapper.get()) {
            return (ObjectWriter)this.defaultWriter.get();
        }
        return this.objectWriterMap.computeIfAbsent(effectiveMapper, new Function<ObjectMapper, ObjectWriter>(){

            @Override
            public ObjectWriter apply(ObjectMapper objectMapper) {
                return JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)effectiveMapper);
            }
        });
    }

    private ObjectMapper getEffectiveMapper(final Object o, ServerRequestContext context) {
        ObjectMapper effectiveMapper = (ObjectMapper)this.originalMapper.get();
        ContextResolver contextResolver = this.providers.getContextResolver(ObjectMapper.class, context.getResponseMediaType());
        if (contextResolver == null) {
            contextResolver = this.providers.getContextResolver(ObjectMapper.class, null);
        }
        if (contextResolver != null) {
            final ContextResolver cr = contextResolver;
            ObjectMapper mapperFromContextResolver = this.contextResolverMap.computeIfAbsent(o.getClass(), new Function<Class<?>, ObjectMapper>(){

                @Override
                public ObjectMapper apply(Class<?> aClass) {
                    return (ObjectMapper)cr.getContext(o.getClass());
                }
            });
            if (mapperFromContextResolver != null) {
                effectiveMapper = mapperFromContextResolver;
            }
        }
        return effectiveMapper;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)((ObjectWriter)this.defaultWriter.get()));
    }

    private static class MethodObjectWriterFunction
    implements Function<String, ObjectWriter> {
        private final Class<? extends BiFunction<ObjectMapper, Type, ObjectWriter>> clazz;
        private final Type genericType;
        private final ObjectMapper originalMapper;

        public MethodObjectWriterFunction(Class<? extends BiFunction<ObjectMapper, Type, ObjectWriter>> clazz, Type genericType, ObjectMapper originalMapper) {
            this.clazz = clazz;
            this.genericType = genericType;
            this.originalMapper = originalMapper;
        }

        @Override
        public ObjectWriter apply(String methodId) {
            try {
                BiFunction<ObjectMapper, Type, ObjectWriter> biFunctionInstance = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ObjectWriter objectWriter = biFunctionInstance.apply(this.originalMapper, this.genericType);
                JacksonMessageBodyWriterUtil.setNecessaryJsonFactoryConfig((JsonFactory)objectWriter.getFactory());
                return objectWriter;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

