/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.Console;

public class IoUtils {
    public static String readFromConsole(String kind, String defaultValue, boolean password) {
        Console cons = System.console();
        if (cons == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new RuntimeException(String.format("Console is not active, but %s is required", kind));
        }
        String prompt = String.format("Enter %s", kind) + (defaultValue != null ? String.format(" [%s]:", defaultValue) : ":");
        if (password) {
            char[] passwd = cons.readPassword(prompt, new Object[0]);
            if (passwd != null) {
                return new String(passwd);
            }
        } else {
            return cons.readLine(prompt, new Object[0]);
        }
        throw new RuntimeException(String.format("No %s provided", kind));
    }

    public static String readPasswordFromConsole(String kind) {
        return IoUtils.readFromConsole(kind, null, true);
    }

    public static String readLineFromConsole(String kind, String defaultValue) {
        return IoUtils.readFromConsole(kind, defaultValue, false);
    }
}

