/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.JBossLog;
import org.jboss.logging.Logger;

public class JBossLogFactory
extends LogFactory {
    private static final Collection<String> UNSUPPORTED_PROPERTIES = Arrays.asList("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.Log", "org.apache.commons.logging.log");
    private final Map<String, Object> attributeMap = Collections.synchronizedMap(new HashMap());
    private final Logger logger = Logger.getLogger(JBossLogFactory.class.getPackage().getName());

    @Override
    public Object getAttribute(String name) {
        return this.getAttributeMap().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAttributeNames() {
        String[] names;
        Map<String, Object> attributes;
        Map<String, Object> map = attributes = this.getAttributeMap();
        synchronized (map) {
            Set<String> s = attributes.keySet();
            names = s.toArray(new String[s.size()]);
        }
        return names;
    }

    @Override
    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String name) throws LogConfigurationException {
        return new JBossLog(name);
    }

    @Override
    public void release() {
        this.getAttributeMap().clear();
    }

    @Override
    public void removeAttribute(String name) {
        this.getAttributeMap().remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        Map<String, Object> attributes = this.getAttributeMap();
        if (value == null) {
            attributes.remove(name);
        } else if (!(value instanceof String)) {
            this.logger.warnf("Attribute values must be of type java.lang.String. Attribute %s with value %s will be ignored.", (Object)name, value);
        } else if (UNSUPPORTED_PROPERTIES.contains(name)) {
            this.logger.warnf("Attribute %s is not supported. Value %s will be ignored.", (Object)name, value);
        } else {
            attributes.put(name, value);
        }
    }

    private Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }
}

