/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;

public class Stamped<V>
implements Comparable<Stamped<V>> {
    public final V value;
    public final long timestamp;

    Stamped(V value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(Stamped<V> other) {
        long otherTimestamp = other.timestamp;
        if (this.timestamp < otherTimestamp) {
            return -1;
        }
        if (this.timestamp > otherTimestamp) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        long otherTimestamp = ((Stamped)other).timestamp;
        return this.timestamp == otherTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }
}

