/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ShareMemberDescription;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ShareGroupDescription {
    private final String groupId;
    private final Collection<ShareMemberDescription> members;
    private final GroupState groupState;
    private final Node coordinator;
    private final int groupEpoch;
    private final int targetAssignmentEpoch;
    private final Set<AclOperation> authorizedOperations;

    public ShareGroupDescription(String groupId, Collection<ShareMemberDescription> members, GroupState groupState, Node coordinator, int groupEpoch, int targetAssignmentEpoch) {
        this(groupId, members, groupState, coordinator, groupEpoch, targetAssignmentEpoch, Collections.emptySet());
    }

    public ShareGroupDescription(String groupId, Collection<ShareMemberDescription> members, GroupState groupState, Node coordinator, int groupEpoch, int targetAssignmentEpoch, Set<AclOperation> authorizedOperations) {
        this.groupId = groupId == null ? "" : groupId;
        this.members = members == null ? Collections.emptyList() : List.copyOf(members);
        this.groupState = groupState;
        this.coordinator = coordinator;
        this.groupEpoch = groupEpoch;
        this.targetAssignmentEpoch = targetAssignmentEpoch;
        this.authorizedOperations = authorizedOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareGroupDescription that = (ShareGroupDescription)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.members, that.members) && this.groupState == that.groupState && Objects.equals(this.coordinator, that.coordinator) && this.groupEpoch == that.groupEpoch && this.targetAssignmentEpoch == that.targetAssignmentEpoch && Objects.equals(this.authorizedOperations, that.authorizedOperations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.members, this.groupState, this.coordinator, this.groupEpoch, this.targetAssignmentEpoch, this.authorizedOperations});
    }

    public String groupId() {
        return this.groupId;
    }

    public Collection<ShareMemberDescription> members() {
        return this.members;
    }

    public GroupState groupState() {
        return this.groupState;
    }

    public Node coordinator() {
        return this.coordinator;
    }

    public Set<AclOperation> authorizedOperations() {
        return this.authorizedOperations;
    }

    public int groupEpoch() {
        return this.groupEpoch;
    }

    public int targetAssignmentEpoch() {
        return this.targetAssignmentEpoch;
    }

    public String toString() {
        return "(groupId=" + this.groupId + ", members=" + this.members.stream().map(ShareMemberDescription::toString).collect(Collectors.joining(",")) + ", groupState=" + String.valueOf((Object)this.groupState) + ", coordinator=" + String.valueOf(this.coordinator) + ", groupEpoch=" + this.groupEpoch + ", targetAssignmentEpoch=" + this.targetAssignmentEpoch + ", authorizedOperations=" + String.valueOf(this.authorizedOperations) + ")";
    }
}

