/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Locale;
import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Stable
public class RaftVoterEndpoint {
    private final String listener;
    private final String host;
    private final int port;

    static String requireNonNullAllCapsNonEmpty(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        if (!input.trim().equals(input)) {
            throw new IllegalArgumentException("Leading or trailing whitespace is not allowed.");
        }
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Empty string is not allowed.");
        }
        if (!input.toUpperCase(Locale.ROOT).equals(input)) {
            throw new IllegalArgumentException("String must be UPPERCASE.");
        }
        return input;
    }

    public RaftVoterEndpoint(String listener, String host, int port) {
        this.listener = RaftVoterEndpoint.requireNonNullAllCapsNonEmpty(listener);
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public String listener() {
        return this.listener;
    }

    @Deprecated(since="4.1", forRemoval=true)
    public String name() {
        return this.listener;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        RaftVoterEndpoint other = (RaftVoterEndpoint)o;
        return this.listener.equals(other.listener) && this.host.equals(other.host) && this.port == other.port;
    }

    public int hashCode() {
        return Objects.hash(this.listener, this.host, this.port);
    }

    public String toString() {
        Object hostString = this.host.contains(":") ? "[" + this.host + "]" : this.host;
        return this.listener + "://" + (String)hostString + ":" + this.port;
    }
}

