/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class GroupListing {
    private final String groupId;
    private final Optional<GroupType> type;
    private final String protocol;
    private final Optional<GroupState> groupState;

    public GroupListing(String groupId, Optional<GroupType> type, String protocol, Optional<GroupState> groupState) {
        this.groupId = groupId;
        this.type = Objects.requireNonNull(type);
        this.protocol = protocol;
        this.groupState = groupState;
    }

    public String groupId() {
        return this.groupId;
    }

    public Optional<GroupType> type() {
        return this.type;
    }

    public String protocol() {
        return this.protocol;
    }

    public Optional<GroupState> groupState() {
        return this.groupState;
    }

    public boolean isSimpleConsumerGroup() {
        return this.type.filter(gt -> gt == GroupType.CLASSIC).isPresent() && this.protocol.isEmpty();
    }

    public String toString() {
        return "(groupId='" + this.groupId + "', type=" + this.type.map(GroupType::toString).orElse("none") + ", protocol='" + this.protocol + "', groupState=" + this.groupState.map(GroupState::toString).orElse("none") + ")";
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.type, this.protocol, this.groupState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupListing)) {
            return false;
        }
        GroupListing that = (GroupListing)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.type, that.type) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.groupState, that.groupState);
    }
}

