/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.SchemaProjectorException;

public class SchemaProjector {
    private static final Set<AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>> PROMOTABLE = new HashSet<AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>>();

    public static Object project(Schema source, Object record, Schema target) throws SchemaProjectorException {
        SchemaProjector.checkMaybeCompatible(source, target);
        if (source.isOptional() && !target.isOptional()) {
            if (target.defaultValue() != null) {
                if (record != null) {
                    return SchemaProjector.projectRequiredSchema(source, record, target);
                }
                return target.defaultValue();
            }
            throw new SchemaProjectorException("Writer schema is optional, however, target schema does not provide a default value.");
        }
        if (record != null) {
            return SchemaProjector.projectRequiredSchema(source, record, target);
        }
        return null;
    }

    private static Object projectRequiredSchema(Schema source, Object record, Schema target) throws SchemaProjectorException {
        switch (target.type()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT32: 
            case FLOAT64: 
            case BOOLEAN: 
            case BYTES: 
            case STRING: {
                return SchemaProjector.projectPrimitive(source, record, target);
            }
            case STRUCT: {
                return SchemaProjector.projectStruct(source, (Struct)record, target);
            }
            case ARRAY: {
                return SchemaProjector.projectArray(source, record, target);
            }
            case MAP: {
                return SchemaProjector.projectMap(source, record, target);
            }
        }
        return null;
    }

    private static Object projectStruct(Schema source, Struct sourceStruct, Schema target) throws SchemaProjectorException {
        Struct targetStruct = new Struct(target);
        for (Field targetField : target.fields()) {
            String fieldName = targetField.name();
            Field sourceField = source.field(fieldName);
            if (sourceField != null) {
                Object sourceFieldValue = sourceStruct.get(fieldName);
                try {
                    Object targetFieldValue = SchemaProjector.project(sourceField.schema(), sourceFieldValue, targetField.schema());
                    targetStruct.put(fieldName, targetFieldValue);
                    continue;
                }
                catch (SchemaProjectorException e) {
                    throw new SchemaProjectorException("Error projecting " + sourceField.name(), (Throwable)((Object)e));
                }
            }
            if (targetField.schema().isOptional()) continue;
            if (targetField.schema().defaultValue() != null) {
                targetStruct.put(fieldName, targetField.schema().defaultValue());
                continue;
            }
            throw new SchemaProjectorException("Required field `" + fieldName + "` is missing from source schema: " + String.valueOf(source));
        }
        return targetStruct;
    }

    private static void checkMaybeCompatible(Schema source, Schema target) {
        if (source.type() != target.type() && !SchemaProjector.isPromotable(source.type(), target.type())) {
            throw new SchemaProjectorException("Schema type mismatch. source type: " + String.valueOf((Object)source.type()) + " and target type: " + String.valueOf((Object)target.type()));
        }
        if (!Objects.equals(source.name(), target.name())) {
            throw new SchemaProjectorException("Schema name mismatch. source name: " + source.name() + " and target name: " + target.name());
        }
        if (!Objects.equals(source.parameters(), target.parameters())) {
            throw new SchemaProjectorException("Schema parameters not equal. source parameters: " + String.valueOf(source.parameters()) + " and target parameters: " + String.valueOf(target.parameters()));
        }
    }

    private static Object projectArray(Schema source, Object record, Schema target) throws SchemaProjectorException {
        List array = (List)record;
        ArrayList<Object> retArray = new ArrayList<Object>();
        for (Object entry : array) {
            retArray.add(SchemaProjector.project(source.valueSchema(), entry, target.valueSchema()));
        }
        return retArray;
    }

    private static Object projectMap(Schema source, Object record, Schema target) throws SchemaProjectorException {
        Map map = (Map)record;
        HashMap<Object, Object> retMap = new HashMap<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object retKey = SchemaProjector.project(source.keySchema(), key, target.keySchema());
            Object retValue = SchemaProjector.project(source.valueSchema(), value, target.valueSchema());
            retMap.put(retKey, retValue);
        }
        return retMap;
    }

    private static Object projectPrimitive(Schema source, Object record, Schema target) throws SchemaProjectorException {
        Object result;
        block11: {
            block10: {
                assert (source.type().isPrimitive());
                assert (target.type().isPrimitive());
                if (!SchemaProjector.isPromotable(source.type(), target.type()) || !(record instanceof Number)) break block10;
                Number numberRecord = (Number)record;
                switch (target.type()) {
                    case INT8: {
                        result = numberRecord.byteValue();
                        break block11;
                    }
                    case INT16: {
                        result = numberRecord.shortValue();
                        break block11;
                    }
                    case INT32: {
                        result = numberRecord.intValue();
                        break block11;
                    }
                    case INT64: {
                        result = numberRecord.longValue();
                        break block11;
                    }
                    case FLOAT32: {
                        result = Float.valueOf(numberRecord.floatValue());
                        break block11;
                    }
                    case FLOAT64: {
                        result = numberRecord.doubleValue();
                        break block11;
                    }
                    default: {
                        throw new SchemaProjectorException("Not promotable type.");
                    }
                }
            }
            result = record;
        }
        return result;
    }

    private static boolean isPromotable(Schema.Type sourceType, Schema.Type targetType) {
        return PROMOTABLE.contains(new AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>(sourceType, targetType));
    }

    static {
        Schema.Type[] promotableTypes = new Schema.Type[]{Schema.Type.INT8, Schema.Type.INT16, Schema.Type.INT32, Schema.Type.INT64, Schema.Type.FLOAT32, Schema.Type.FLOAT64};
        for (int i = 0; i < promotableTypes.length; ++i) {
            for (int j = i; j < promotableTypes.length; ++j) {
                PROMOTABLE.add(new AbstractMap.SimpleImmutableEntry<Schema.Type, Schema.Type>(promotableTypes[i], promotableTypes[j]));
            }
        }
    }
}

