/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class NamedCacheMetrics {
    private static final String HIT_RATIO = "hit-ratio";
    private static final String HIT_RATIO_AVG_DESCRIPTION = "The average cache hit ratio";
    private static final String HIT_RATIO_MIN_DESCRIPTION = "The minimum cache hit ratio";
    private static final String HIT_RATIO_MAX_DESCRIPTION = "The maximum cache hit ratio";

    private NamedCacheMetrics() {
    }

    public static Sensor hitRatioSensor(StreamsMetricsImpl streamsMetrics, String threadId, String taskName, String storeName) {
        String hitRatioName = HIT_RATIO;
        Sensor hitRatioSensor = streamsMetrics.cacheLevelSensor(threadId, taskName, storeName, hitRatioName, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor(hitRatioSensor, "stream-record-cache-metrics", streamsMetrics.cacheLevelTagMap(threadId, taskName, storeName), hitRatioName, HIT_RATIO_AVG_DESCRIPTION, HIT_RATIO_MIN_DESCRIPTION, HIT_RATIO_MAX_DESCRIPTION);
        return hitRatioSensor;
    }
}

