/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowStore;

public class RocksDbIndexedTimeOrderedWindowBytesStoreSupplier
implements WindowBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;
    private final long segmentInterval;
    private final long windowSize;
    private final boolean retainDuplicates;
    private final WindowStoreTypes windowStoreType;

    public static RocksDbIndexedTimeOrderedWindowBytesStoreSupplier create(String name, Duration retentionPeriod, Duration windowSize, boolean retainDuplicates, boolean hasIndex) {
        Objects.requireNonNull(name, "name cannot be null");
        String rpMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(retentionPeriod, "retentionPeriod");
        long retentionMs = ApiUtils.validateMillisecondDuration(retentionPeriod, rpMsgPrefix);
        String wsMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(windowSize, "windowSize");
        long windowSizeMs = ApiUtils.validateMillisecondDuration(windowSize, wsMsgPrefix);
        long defaultSegmentInterval = Math.max(retentionMs / 2L, 60000L);
        if (retentionMs < 0L) {
            throw new IllegalArgumentException("retentionPeriod cannot be negative");
        }
        if (windowSizeMs < 0L) {
            throw new IllegalArgumentException("windowSize cannot be negative");
        }
        if (defaultSegmentInterval < 1L) {
            throw new IllegalArgumentException("segmentInterval cannot be zero or negative");
        }
        if (windowSizeMs > retentionMs) {
            throw new IllegalArgumentException("The retention period of the window store " + name + " must be no smaller than its window size. Got size=[" + windowSizeMs + "], retention=[" + retentionMs + "]");
        }
        return new RocksDbIndexedTimeOrderedWindowBytesStoreSupplier(name, retentionMs, defaultSegmentInterval, windowSizeMs, retainDuplicates, hasIndex);
    }

    public RocksDbIndexedTimeOrderedWindowBytesStoreSupplier(String name, long retentionPeriod, long segmentInterval, long windowSize, boolean retainDuplicates, boolean withIndex) {
        this(name, retentionPeriod, segmentInterval, windowSize, retainDuplicates, withIndex ? WindowStoreTypes.INDEXED_WINDOW_STORE : WindowStoreTypes.DEFAULT_WINDOW_STORE);
    }

    public RocksDbIndexedTimeOrderedWindowBytesStoreSupplier(String name, long retentionPeriod, long segmentInterval, long windowSize, boolean retainDuplicates, WindowStoreTypes windowStoreType) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.segmentInterval = segmentInterval;
        this.windowSize = windowSize;
        this.retainDuplicates = retainDuplicates;
        this.windowStoreType = windowStoreType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public WindowStore<Bytes, byte[]> get() {
        switch (this.windowStoreType) {
            case DEFAULT_WINDOW_STORE: {
                return new RocksDBTimeOrderedWindowStore(new RocksDBTimeOrderedWindowSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentInterval, false), this.retainDuplicates, this.windowSize);
            }
            case INDEXED_WINDOW_STORE: {
                return new RocksDBTimeOrderedWindowStore(new RocksDBTimeOrderedWindowSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentInterval, true), this.retainDuplicates, this.windowSize);
            }
        }
        throw new IllegalArgumentException("invalid window store type: " + (Object)((Object)this.windowStoreType));
    }

    @Override
    public String metricsScope() {
        return "rocksdb-window";
    }

    @Override
    public long segmentIntervalMs() {
        return this.segmentInterval;
    }

    @Override
    public long windowSize() {
        return this.windowSize;
    }

    @Override
    public boolean retainDuplicates() {
        return this.retainDuplicates;
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }

    public String toString() {
        return "RocksDbIndexedTimeOrderedWindowBytesStoreSupplier{name='" + this.name + '\'' + ", retentionPeriod=" + this.retentionPeriod + ", segmentInterval=" + this.segmentInterval + ", windowSize=" + this.windowSize + ", retainDuplicates=" + this.retainDuplicates + ", windowStoreType=" + (Object)((Object)this.windowStoreType) + '}';
    }

    public static enum WindowStoreTypes {
        DEFAULT_WINDOW_STORE,
        INDEXED_WINDOW_STORE;

    }
}

