/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.List;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.internals.FailedQueryResult;
import org.apache.kafka.streams.query.internals.SucceededQueryResult;

public interface QueryResult<R> {
    public static <R> QueryResult<R> forResult(R result) {
        return new SucceededQueryResult<R>(result);
    }

    public static <R> QueryResult<R> forFailure(FailureReason failureReason, String failureMessage) {
        return new FailedQueryResult(failureReason, failureMessage);
    }

    public static <R> QueryResult<R> forUnknownQueryType(Query<R> query, StateStore store) {
        return QueryResult.forFailure(FailureReason.UNKNOWN_QUERY_TYPE, "This store (" + store.getClass() + ") doesn't know how to execute the given query (" + query + "). Contact the store maintainer if you need support for a new query type.");
    }

    public static <R> QueryResult<R> notUpToBound(Position currentPosition, PositionBound positionBound, Integer partition) {
        if (partition == null) {
            return new FailedQueryResult(FailureReason.NOT_UP_TO_BOUND, "The store is not initialized yet, so it is not yet up to the bound " + positionBound);
        }
        return new FailedQueryResult(FailureReason.NOT_UP_TO_BOUND, "For store partition " + partition + ", the current position " + currentPosition + " is not yet up to the bound " + positionBound);
    }

    public void addExecutionInfo(String var1);

    public void setPosition(Position var1);

    public boolean isSuccess();

    public boolean isFailure();

    public List<String> getExecutionInfo();

    public Position getPosition();

    public FailureReason getFailureReason();

    public String getFailureMessage();

    public R getResult();
}

