/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.KStreamSessionWindowAggregate;
import org.apache.kafka.streams.kstream.internals.KStreamSlidingWindowAggregate;
import org.apache.kafka.streams.kstream.internals.KStreamWindowAggregate;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.StatefulProcessorNode;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;

public final class GraphGraceSearchUtil {
    private GraphGraceSearchUtil() {
    }

    public static long findAndVerifyWindowGrace(GraphNode graphNode) {
        return GraphGraceSearchUtil.findAndVerifyWindowGrace(graphNode, "");
    }

    private static long findAndVerifyWindowGrace(GraphNode graphNode, String chain) {
        String newChain;
        if (graphNode == null) {
            throw new TopologyException("Window close time is only defined for windowed computations. Got [" + chain + "].");
        }
        Long gracePeriod = GraphGraceSearchUtil.extractGracePeriod(graphNode);
        if (gracePeriod != null) {
            return gracePeriod;
        }
        String string = newChain = chain.equals("") ? graphNode.nodeName() : graphNode.nodeName() + "->" + chain;
        if (graphNode.parentNodes().isEmpty()) {
            throw new TopologyException("Window close time is only defined for windowed computations. Got [" + newChain + "].");
        }
        long inheritedGrace = -1L;
        for (GraphNode parentNode : graphNode.parentNodes()) {
            long parentGrace = GraphGraceSearchUtil.findAndVerifyWindowGrace(parentNode, newChain);
            inheritedGrace = Math.max(inheritedGrace, parentGrace);
        }
        if (inheritedGrace == -1L) {
            throw new IllegalStateException();
        }
        return inheritedGrace;
    }

    private static Long extractGracePeriod(GraphNode node) {
        if (node instanceof StatefulProcessorNode) {
            ProcessorSupplier processorSupplier = ((StatefulProcessorNode)node).processorParameters().processorSupplier();
            if (processorSupplier instanceof KStreamWindowAggregate) {
                KStreamWindowAggregate kStreamWindowAggregate = (KStreamWindowAggregate)processorSupplier;
                Windows windows = kStreamWindowAggregate.windows();
                return windows.gracePeriodMs();
            }
            if (processorSupplier instanceof KStreamSessionWindowAggregate) {
                KStreamSessionWindowAggregate kStreamSessionWindowAggregate = (KStreamSessionWindowAggregate)processorSupplier;
                SessionWindows windows = kStreamSessionWindowAggregate.windows();
                return windows.gracePeriodMs() + windows.inactivityGap();
            }
            if (processorSupplier instanceof KStreamSlidingWindowAggregate) {
                KStreamSlidingWindowAggregate kStreamSlidingWindowAggregate = (KStreamSlidingWindowAggregate)processorSupplier;
                SlidingWindows windows = kStreamSlidingWindowAggregate.windows();
                return windows.gracePeriodMs();
            }
            return null;
        }
        return null;
    }
}

