/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.kstream.internals.emitstrategy.WindowCloseStrategy;
import org.apache.kafka.streams.kstream.internals.emitstrategy.WindowUpdateStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EmitStrategy {
    public static final Logger log = LoggerFactory.getLogger(EmitStrategy.class);

    public StrategyType type();

    public static EmitStrategy onWindowClose() {
        return new WindowCloseStrategy();
    }

    public static EmitStrategy onWindowUpdate() {
        return new WindowUpdateStrategy();
    }

    public static enum StrategyType {
        ON_WINDOW_UPDATE(0, new WindowUpdateStrategy()),
        ON_WINDOW_CLOSE(1, new WindowCloseStrategy());

        private final short code;
        private final EmitStrategy strategy;
        private static final Map<Short, EmitStrategy> TYPE_TO_STRATEGY;

        private short code() {
            return this.code;
        }

        private EmitStrategy strategy() {
            return this.strategy;
        }

        private StrategyType(int code, EmitStrategy strategy) {
            this.code = (short)code;
            this.strategy = strategy;
        }

        public static EmitStrategy forType(StrategyType type) {
            return TYPE_TO_STRATEGY.get(type.code());
        }

        static {
            TYPE_TO_STRATEGY = new HashMap<Short, EmitStrategy>();
            for (StrategyType type : StrategyType.values()) {
                if (TYPE_TO_STRATEGY.put(type.code(), type.strategy()) == null) continue;
                throw new IllegalStateException("Code " + type.code() + " for type " + (Object)((Object)type) + " has already been used");
            }
        }
    }
}

