/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.tools.TerseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestWorkspace {
    private static final Logger log = LoggerFactory.getLogger(ManifestWorkspace.class);
    private static final String MANIFEST_PREFIX = "META-INF/services/";
    private static final Path MANAGED_PATH = Paths.get("connect-plugin-path-shim-1.0.0.jar", new String[0]);
    private static final String MANIFEST_HEADER = "# Generated by connect-plugin-path.sh " + AppInfoParser.getVersion();
    private final PrintStream out;
    private final List<SourceWorkspace<?>> workspaces;
    private final Map<Path, Path> temporaryOverlayFiles;

    public ManifestWorkspace(PrintStream out) {
        this.out = out;
        this.workspaces = new ArrayList();
        this.temporaryOverlayFiles = new HashMap<Path, Path>();
    }

    public SourceWorkspace<?> forSource(PluginSource source) throws IOException {
        SourceWorkspace sourceWorkspace;
        switch (source.type()) {
            case CLASSPATH: {
                sourceWorkspace = new ClasspathWorkspace(source);
                break;
            }
            case MULTI_JAR: {
                sourceWorkspace = new MultiJarWorkspace(source);
                break;
            }
            case SINGLE_JAR: {
                sourceWorkspace = new SingleJarWorkspace(source);
                break;
            }
            case CLASS_HIERARCHY: {
                sourceWorkspace = new ClassHierarchyWorkspace(source);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown source type " + source.type());
            }
        }
        this.workspaces.add(sourceWorkspace);
        return sourceWorkspace;
    }

    public boolean commit(boolean dryRun) throws IOException, TerseException {
        boolean changed = false;
        for (SourceWorkspace<?> workspace : this.workspaces) {
            changed |= workspace.commit(dryRun);
        }
        return changed;
    }

    private boolean startSync(boolean dryRun, Path syncLocation, Map<PluginType, Set<String>> before, Map<PluginType, Set<String>> after) {
        Objects.requireNonNull(syncLocation, "syncLocation must be non-null");
        Objects.requireNonNull(before, "before must be non-null");
        Objects.requireNonNull(after, "after must be non-null");
        if (before.equals(after)) {
            return false;
        }
        HashSet added = new HashSet();
        after.values().forEach(added::addAll);
        before.values().forEach(added::removeAll);
        HashSet removed = new HashSet();
        before.values().forEach(removed::addAll);
        after.values().forEach(removed::removeAll);
        this.out.printf("%sSync\t%s Add %s Remove %s%n", dryRun ? "Dry Run " : "", syncLocation, added.size(), removed.size());
        for (String add : added) {
            this.out.printf("\tAdd\t%s%n", add);
        }
        for (String rem : removed) {
            this.out.printf("\tRemove\t%s%n", rem);
        }
        return true;
    }

    private void rewriteJar(boolean dryRun, Path jarPath, Map<PluginType, Set<String>> manifestElements) throws IOException, TerseException {
        Objects.requireNonNull(jarPath, "jarPath must be non-null");
        Objects.requireNonNull(manifestElements, "manifestState must be non-null");
        Path writableJar = this.getWritablePath(dryRun, jarPath);
        if (ManifestWorkspace.nonEmpty(manifestElements) && !Files.exists(writableJar, new LinkOption[0])) {
            log.debug("Create {}", (Object)jarPath);
            this.createJar(writableJar);
        }
        try (FileSystem jar = FileSystems.newFileSystem(new URI("jar", writableJar.toUri().toString(), ""), Collections.emptyMap());){
            Path zipRoot = jar.getRootDirectories().iterator().next();
            this.rewriteClassHierarchyManifest(false, zipRoot, manifestElements);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (Files.exists(writableJar, new LinkOption[0]) && this.jarIsEmpty(writableJar)) {
            Files.delete(writableJar);
        }
    }

    private static boolean nonEmpty(Map<PluginType, Set<String>> manifestElements) {
        return !manifestElements.values().stream().allMatch(Collection::isEmpty);
    }

    private void createJar(Path path) throws IOException {
        Objects.requireNonNull(path, "path must be non-null");
        try (ZipOutputStream stream = new ZipOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));){
            stream.closeEntry();
        }
    }

    private boolean jarIsEmpty(Path path) throws IOException {
        Objects.requireNonNull(path, "path must be non-null");
        try (ZipInputStream stream = new ZipInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
            boolean bl = stream.getNextEntry() == null;
            return bl;
        }
    }

    private void rewriteClassHierarchyManifest(boolean dryRun, Path pluginLocation, Map<PluginType, Set<String>> manifestElements) throws IOException, TerseException {
        Objects.requireNonNull(pluginLocation, "pluginLocation must be non-null");
        Objects.requireNonNull(manifestElements, "manifestState must be non-null");
        if (!Files.exists(pluginLocation, new LinkOption[0])) {
            throw new TerseException(pluginLocation + " does not exist");
        }
        if (!Files.isWritable(pluginLocation)) {
            throw new TerseException(pluginLocation + " is not writable");
        }
        Path metaInfPath = pluginLocation.resolve("META-INF");
        Path servicesPath = metaInfPath.resolve("services");
        if (ManifestWorkspace.nonEmpty(manifestElements) && !Files.exists(servicesPath, new LinkOption[0]) && !dryRun) {
            Files.createDirectories(servicesPath, new FileAttribute[0]);
        }
        for (Map.Entry<PluginType, Set<String>> manifest : manifestElements.entrySet()) {
            PluginType type = manifest.getKey();
            Set<String> elements = manifest.getValue();
            this.rewriteManifestFile(dryRun, servicesPath.resolve(type.superClass().getName()), elements);
        }
        this.deleteDirectoryIfEmpty(dryRun, servicesPath);
        this.deleteDirectoryIfEmpty(dryRun, metaInfPath);
    }

    private void deleteDirectoryIfEmpty(boolean dryRun, Path path) throws IOException, TerseException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (!Files.isWritable(path)) {
            throw new TerseException(path + " is not writable");
        }
        try (Stream<Path> list = Files.list(path);){
            if (list.findAny().isPresent()) {
                return;
            }
        }
        log.debug("Delete {}", (Object)path);
        if (!dryRun) {
            Files.delete(path);
        }
    }

    private void rewriteManifestFile(boolean dryRun, Path filePath, Set<String> elements) throws IOException, TerseException {
        Objects.requireNonNull(filePath, "filePath must be non-null");
        Objects.requireNonNull(elements, "elements must be non-null");
        Path writableFile = this.getWritablePath(dryRun, filePath);
        if (elements.isEmpty()) {
            if (Files.exists(filePath, new LinkOption[0])) {
                log.debug("Delete {}", (Object)filePath);
                if (!dryRun) {
                    Files.delete(writableFile);
                }
            }
        } else {
            if (!Files.exists(filePath, new LinkOption[0])) {
                log.debug("Create {}", (Object)filePath);
            }
            log.debug("Write {} with content {}", (Object)filePath, elements);
            if (!dryRun) {
                try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(writableFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));){
                    byte[] newline = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
                    ((OutputStream)stream).write(MANIFEST_HEADER.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)stream).write(newline);
                    for (String element : elements) {
                        ((OutputStream)stream).write(element.getBytes(StandardCharsets.UTF_8));
                        ((OutputStream)stream).write(newline);
                    }
                }
            }
        }
    }

    private Path getWritablePath(boolean dryRun, Path path) throws IOException, TerseException {
        Objects.requireNonNull(path, "path must be non-null");
        for (Path parent = path; parent != null && !Files.isWritable(parent); parent = parent.getParent()) {
            if (!Files.exists(parent, new LinkOption[0]) || Files.isWritable(parent)) continue;
            throw new TerseException("Path " + path + " must be writable");
        }
        if (dryRun) {
            if (!this.temporaryOverlayFiles.containsKey(path)) {
                Path fileName = path.getFileName();
                String suffix = fileName != null ? fileName.toString() : ".temp";
                Path temp = Files.createTempFile("connect-plugin-path-temporary-", suffix, new FileAttribute[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    Files.copy(path, temp, StandardCopyOption.REPLACE_EXISTING);
                    temp.toFile().deleteOnExit();
                } else {
                    Files.delete(temp);
                }
                this.temporaryOverlayFiles.put(path, temp);
                return temp;
            }
            return this.temporaryOverlayFiles.get(path);
        }
        return path;
    }

    private static Set<String> parse(URL u) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            URLConnection uc = u.openConnection();
            uc.setUseCaches(false);
            try (InputStream in = uc.getInputStream();
                 BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                int lc = 1;
                while ((lc = ManifestWorkspace.parseLine(u, r, lc, names)) >= 0) {
                }
            }
        }
        catch (IOException x) {
            throw new RuntimeException("Error accessing configuration file", x);
        }
        return names;
    }

    private static int parseLine(URL u, BufferedReader r, int lc, Set<String> names) throws IOException {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int start;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                throw new IOException("Illegal configuration-file syntax in " + u);
            }
            int cp = ln.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                throw new IOException("Illegal provider-class name: " + ln + " in " + u);
            }
            for (int i = start = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                throw new IOException("Illegal provider-class name: " + ln + " in " + u);
            }
            names.add(ln);
        }
        return lc + 1;
    }

    private class ClasspathWorkspace
    extends SourceWorkspace<Map<Path, Map<PluginType, Set<String>>>> {
        private ClasspathWorkspace(PluginSource source) throws IOException {
            super(source);
        }

        @Override
        protected Map<Path, Map<PluginType, Set<String>>> load(PluginSource source) throws IOException {
            HashMap<Path, Map<PluginType, Set<String>>> manifestsBySubLocation = new HashMap<Path, Map<PluginType, Set<String>>>();
            for (URL url : source.urls()) {
                Path jarPath = Paths.get(url.getPath(), new String[0]);
                manifestsBySubLocation.put(jarPath, ClasspathWorkspace.loadManifest(ClasspathWorkspace.jarBaseUrl(url)));
            }
            return manifestsBySubLocation;
        }

        @Override
        public boolean hasManifest(PluginType type, String className) {
            return ((Map)this.manifests).values().stream().map(m -> (Set)m.get(type)).anyMatch(s -> s.contains(className));
        }

        @Override
        public void forEach(BiConsumer<String, PluginType> consumer) {
            ((Map)this.manifests).values().forEach((? super T m) -> ClasspathWorkspace.forEach(m, consumer));
        }

        @Override
        public void addManifest(PluginType type, String pluginClass) {
            throw new UnsupportedOperationException("Cannot change the contents of the classpath");
        }

        @Override
        public void removeManifest(PluginType type, String pluginClass) {
            throw new UnsupportedOperationException("Cannot change the contents of the classpath");
        }

        @Override
        protected boolean commit(boolean dryRun) throws IOException, TerseException {
            return false;
        }
    }

    private class MultiJarWorkspace
    extends ClasspathWorkspace {
        private MultiJarWorkspace(PluginSource source) throws IOException {
            super(source);
        }

        @Override
        protected Map<Path, Map<PluginType, Set<String>>> load(PluginSource source) throws IOException {
            Object manifests = super.load(source);
            Path managedPath = source.location().resolve(MANAGED_PATH);
            URL url = managedPath.toUri().toURL();
            manifests.put(managedPath, MultiJarWorkspace.loadManifest(MultiJarWorkspace.jarBaseUrl(url)));
            return manifests;
        }

        @Override
        public void addManifest(PluginType type, String pluginClass) {
            ((Set)((Map)((Map)this.manifests).get(this.location().resolve(MANAGED_PATH))).get(type)).add(pluginClass);
        }

        @Override
        public void removeManifest(PluginType type, String pluginClass) {
            for (Map manifestState : ((Map)this.manifests).values()) {
                ((Set)manifestState.get(type)).remove(pluginClass);
            }
        }

        @Override
        public boolean commit(boolean dryRun) throws IOException, TerseException {
            boolean changed = false;
            for (Map.Entry manifestSource : ((Map)this.manifests).entrySet()) {
                Map after;
                Map before;
                Path jarPath = (Path)manifestSource.getKey();
                if (!ManifestWorkspace.this.startSync(dryRun, jarPath, before = (Map)((Map)this.initial).get(jarPath), after = (Map)manifestSource.getValue())) continue;
                ManifestWorkspace.this.rewriteJar(dryRun, jarPath, after);
                changed = true;
            }
            return changed;
        }
    }

    private class SingleJarWorkspace
    extends SourceWorkspace<Map<PluginType, Set<String>>> {
        private SingleJarWorkspace(PluginSource source) throws IOException {
            super(source);
            assert (source.urls().length == 1);
        }

        @Override
        protected Map<PluginType, Set<String>> load(PluginSource source) throws IOException {
            return SingleJarWorkspace.loadManifest(SingleJarWorkspace.jarBaseUrl(source.urls()[0]));
        }

        @Override
        public boolean hasManifest(PluginType type, String className) {
            return ((Set)((Map)this.manifests).get(type)).contains(className);
        }

        @Override
        public void forEach(BiConsumer<String, PluginType> consumer) {
            SingleJarWorkspace.forEach((Map)this.manifests, consumer);
        }

        @Override
        public void addManifest(PluginType type, String pluginClass) {
            ((Set)((Map)this.manifests).get(type)).add(pluginClass);
        }

        @Override
        public void removeManifest(PluginType type, String pluginClass) {
            ((Set)((Map)this.manifests).get(type)).remove(pluginClass);
        }

        @Override
        protected boolean commit(boolean dryRun) throws IOException, TerseException {
            if (ManifestWorkspace.this.startSync(dryRun, this.location(), (Map)this.initial, (Map)this.manifests)) {
                ManifestWorkspace.this.rewriteJar(dryRun, this.location(), (Map)this.manifests);
                return true;
            }
            return false;
        }
    }

    private class ClassHierarchyWorkspace
    extends SingleJarWorkspace {
        private ClassHierarchyWorkspace(PluginSource source) throws IOException {
            super(source);
        }

        @Override
        protected Map<PluginType, Set<String>> load(PluginSource source) throws IOException {
            return ClassHierarchyWorkspace.loadManifest(source.location().toUri().toURL());
        }

        @Override
        protected boolean commit(boolean dryRun) throws IOException, TerseException {
            if (ManifestWorkspace.this.startSync(dryRun, this.location(), (Map)this.initial, (Map)this.manifests)) {
                ManifestWorkspace.this.rewriteClassHierarchyManifest(dryRun, this.location(), (Map)this.manifests);
                return true;
            }
            return false;
        }
    }

    public static abstract class SourceWorkspace<T> {
        private final Path location;
        private final PluginSource.Type type;
        protected final T initial;
        protected final T manifests;

        private SourceWorkspace(PluginSource source) throws IOException {
            this.location = source.location();
            this.type = source.type();
            this.initial = this.load(source);
            this.manifests = this.load(source);
        }

        public Path location() {
            return this.location;
        }

        public PluginSource.Type type() {
            return this.type;
        }

        protected abstract T load(PluginSource var1) throws IOException;

        public abstract boolean hasManifest(PluginType var1, String var2);

        public abstract void forEach(BiConsumer<String, PluginType> var1);

        public abstract void addManifest(PluginType var1, String var2);

        public abstract void removeManifest(PluginType var1, String var2);

        protected abstract boolean commit(boolean var1) throws TerseException, IOException;

        protected static Map<PluginType, Set<String>> loadManifest(URL baseUrl) throws MalformedURLException {
            EnumMap<PluginType, Set<String>> manifests = new EnumMap<PluginType, Set<String>>(PluginType.class);
            for (PluginType type : PluginType.values()) {
                Set result;
                try {
                    URL u = new URL(baseUrl, ManifestWorkspace.MANIFEST_PREFIX + type.superClass().getName());
                    result = ManifestWorkspace.parse(u);
                }
                catch (RuntimeException e) {
                    result = new LinkedHashSet();
                }
                manifests.put(type, result);
            }
            return manifests;
        }

        protected static URL jarBaseUrl(URL fileUrl) throws MalformedURLException {
            return new URL("jar", "", -1, fileUrl + "!/", null);
        }

        protected static void forEach(Map<PluginType, Set<String>> manifests, BiConsumer<String, PluginType> consumer) {
            manifests.forEach((? super K type, ? super V classNames) -> classNames.forEach((? super T className) -> consumer.accept((String)className, (PluginType)type)));
        }
    }
}

