/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ConnectionQuotaEntity {
    public static final String CONNECTION_RATE_SENSOR_NAME = "Connection-Accept-Rate";
    public static final String CONNECTION_RATE_METRIC_NAME = "connection-accept-rate";
    public static final String LISTENER_THROTTLE_PREFIX = "";
    public static final String IP_METRIC_TAG = "ip";
    public static final String IP_THROTTLE_PREFIX = "ip-";
    private final String sensorName;
    private final String metricName;
    private final long sensorExpiration;
    private final Map<String, String> metricTags;

    public static ConnectionQuotaEntity listenerQuotaEntity(String listenerName) {
        return new ConnectionQuotaEntity("Connection-Accept-Rate-" + listenerName, CONNECTION_RATE_METRIC_NAME, Long.MAX_VALUE, Collections.singletonMap("listener", listenerName));
    }

    public static ConnectionQuotaEntity brokerQuotaEntity() {
        return new ConnectionQuotaEntity(CONNECTION_RATE_SENSOR_NAME, "broker-connection-accept-rate", Long.MAX_VALUE, Collections.emptyMap());
    }

    public static ConnectionQuotaEntity ipQuotaEntity(InetAddress ip) {
        return new ConnectionQuotaEntity("Connection-Accept-Rate-" + ip.getHostAddress(), CONNECTION_RATE_METRIC_NAME, TimeUnit.HOURS.toSeconds(1L), Collections.singletonMap(IP_METRIC_TAG, ip.getHostAddress()));
    }

    private ConnectionQuotaEntity(String sensorName, String metricName, long sensorExpiration, Map<String, String> metricTags) {
        this.sensorName = sensorName;
        this.metricName = metricName;
        this.sensorExpiration = sensorExpiration;
        this.metricTags = metricTags;
    }

    public String sensorName() {
        return this.sensorName;
    }

    public String metricName() {
        return this.metricName;
    }

    public long sensorExpiration() {
        return this.sensorExpiration;
    }

    public Map<String, String> metricTags() {
        return this.metricTags;
    }
}

