/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kafka.server.share.ErroneousAndValidPartitionData;
import kafka.server.share.ShareFetchContext;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchMetadata;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.ShareSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class ShareSessionContext
extends ShareFetchContext {
    private static final Logger log = LoggerFactory.getLogger(ShareSessionContext.class);
    private final ShareFetchMetadata reqMetadata;
    private final boolean isSubsequent;
    private Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData;
    private ShareSession session;

    public ShareSessionContext(ShareFetchMetadata reqMetadata, Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData) {
        this.reqMetadata = reqMetadata;
        this.shareFetchData = shareFetchData;
        this.isSubsequent = false;
    }

    public ShareSessionContext(ShareFetchMetadata reqMetadata, ShareSession session) {
        this.reqMetadata = reqMetadata;
        this.session = session;
        this.isSubsequent = true;
    }

    public Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData() {
        return this.shareFetchData;
    }

    public boolean isSubsequent() {
        return this.isSubsequent;
    }

    public ShareSession session() {
        return this.session;
    }

    @Override
    boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ShareFetchResponse throttleResponse(int throttleTimeMs) {
        int sessionEpoch;
        if (!this.isSubsequent) {
            return new ShareFetchResponse(ShareFetchResponse.toMessage((Errors)Errors.NONE, (int)throttleTimeMs, Collections.emptyIterator(), Collections.emptyList()));
        }
        int expectedEpoch = ShareFetchMetadata.nextEpoch((int)this.reqMetadata.epoch());
        ShareSession shareSession = this.session;
        synchronized (shareSession) {
            sessionEpoch = this.session.epoch;
        }
        if (sessionEpoch != expectedEpoch) {
            log.debug("Subsequent share session {} expected epoch {}, but got {}. Possible duplicate request.", new Object[]{this.session.key(), expectedEpoch, sessionEpoch});
            return new ShareFetchResponse(ShareFetchResponse.toMessage((Errors)Errors.INVALID_SHARE_SESSION_EPOCH, (int)throttleTimeMs, Collections.emptyIterator(), Collections.emptyList()));
        }
        return new ShareFetchResponse(ShareFetchResponse.toMessage((Errors)Errors.NONE, (int)throttleTimeMs, Collections.emptyIterator(), Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int responseSize(LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> updates, short version) {
        if (!this.isSubsequent) {
            return ShareFetchResponse.sizeOf((short)version, updates.entrySet().iterator());
        }
        ShareSession shareSession = this.session;
        synchronized (shareSession) {
            int expectedEpoch = ShareFetchMetadata.nextEpoch((int)this.reqMetadata.epoch());
            if (this.session.epoch != expectedEpoch) {
                return ShareFetchResponse.sizeOf((short)version, Collections.emptyIterator());
            }
            return ShareFetchResponse.sizeOf((short)version, (Iterator)new PartitionIterator(updates.entrySet().iterator(), false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ShareFetchResponse updateAndGenerateResponseData(String groupId, Uuid memberId, LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> updates) {
        int sessionEpoch;
        if (!this.isSubsequent) {
            return new ShareFetchResponse(ShareFetchResponse.toMessage((Errors)Errors.NONE, (int)0, updates.entrySet().iterator(), Collections.emptyList()));
        }
        int expectedEpoch = ShareFetchMetadata.nextEpoch((int)this.reqMetadata.epoch());
        ShareSession shareSession = this.session;
        synchronized (shareSession) {
            sessionEpoch = this.session.epoch;
        }
        if (sessionEpoch != expectedEpoch) {
            log.debug("Subsequent share session {} expected epoch {}, but got {}. Possible duplicate request.", new Object[]{this.session.key(), expectedEpoch, sessionEpoch});
            return new ShareFetchResponse(ShareFetchResponse.toMessage((Errors)Errors.INVALID_SHARE_SESSION_EPOCH, (int)0, Collections.emptyIterator(), Collections.emptyList()));
        }
        PartitionIterator partitionIterator = new PartitionIterator(updates.entrySet().iterator(), true);
        while (partitionIterator.hasNext()) {
            partitionIterator.next();
        }
        log.debug("Subsequent share session context with session key {} returning {}", (Object)this.session.key(), (Object)this.partitionsToLogString(updates.keySet()));
        return new ShareFetchResponse(ShareFetchResponse.toMessage((Errors)Errors.NONE, (int)0, updates.entrySet().iterator(), Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ErroneousAndValidPartitionData getErroneousAndValidTopicIdPartitions() {
        if (!this.isSubsequent) {
            return new ErroneousAndValidPartitionData(this.shareFetchData);
        }
        ArrayList<Tuple2<TopicIdPartition, ShareFetchResponseData.PartitionData>> erroneous = new ArrayList<Tuple2<TopicIdPartition, ShareFetchResponseData.PartitionData>>();
        ArrayList<Tuple2<TopicIdPartition, ShareFetchRequest.SharePartitionData>> valid = new ArrayList<Tuple2<TopicIdPartition, ShareFetchRequest.SharePartitionData>>();
        ShareSession shareSession = this.session;
        synchronized (shareSession) {
            this.session.partitionMap().forEach(cachedSharePartition -> {
                TopicIdPartition topicIdPartition = new TopicIdPartition(cachedSharePartition.topicId(), new TopicPartition(cachedSharePartition.topic(), cachedSharePartition.partition()));
                ShareFetchRequest.SharePartitionData reqData = cachedSharePartition.reqData();
                if (topicIdPartition.topic() == null) {
                    erroneous.add(new Tuple2((Object)topicIdPartition, (Object)ShareFetchResponse.partitionResponse((TopicIdPartition)topicIdPartition, (Errors)Errors.UNKNOWN_TOPIC_ID)));
                } else {
                    valid.add(new Tuple2((Object)topicIdPartition, (Object)reqData));
                }
            });
            return new ErroneousAndValidPartitionData(erroneous, valid);
        }
    }

    private class PartitionIterator
    implements Iterator<Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData>> {
        private final Iterator<Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData>> iterator;
        private final boolean updateShareContextAndRemoveUnselected;
        private Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData> nextElement;

        public PartitionIterator(Iterator<Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData>> iterator, boolean updateShareContextAndRemoveUnselected) {
            this.iterator = iterator;
            this.updateShareContextAndRemoveUnselected = updateShareContextAndRemoveUnselected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.nextElement == null && this.iterator.hasNext()) {
                Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData> element = this.iterator.next();
                TopicIdPartition topicPart = element.getKey();
                ShareFetchResponseData.PartitionData respData = element.getValue();
                ShareSession shareSession = ShareSessionContext.this.session;
                synchronized (shareSession) {
                    CachedSharePartition cachedPart = (CachedSharePartition)ShareSessionContext.this.session.partitionMap().find((ImplicitLinkedHashCollection.Element)new CachedSharePartition(topicPart));
                    boolean mustRespond = cachedPart.maybeUpdateResponseData(respData, this.updateShareContextAndRemoveUnselected);
                    if (mustRespond) {
                        this.nextElement = element;
                        if (this.updateShareContextAndRemoveUnselected && ShareFetchResponse.recordsSize((ShareFetchResponseData.PartitionData)respData) > 0) {
                            ShareSessionContext.this.session.partitionMap().remove((Object)cachedPart);
                            ShareSessionContext.this.session.partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                        }
                    } else if (this.updateShareContextAndRemoveUnselected) {
                        this.iterator.remove();
                    }
                }
            }
            return this.nextElement != null;
        }

        @Override
        public Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData> element = this.nextElement;
            this.nextElement = null;
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

