/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.group.share.PartitionInfoData;

public class TopicData<P extends PartitionInfoData> {
    private final Uuid topicId;
    private final List<P> partitions;

    public TopicData(Uuid topicId, List<P> partitions) {
        this.topicId = topicId;
        this.partitions = partitions;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public List<P> partitions() {
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicData topicData = (TopicData)o;
        return Objects.equals(this.topicId, topicData.topicId) && Objects.equals(this.partitions, topicData.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.topicId, this.partitions);
    }

    public String toString() {
        return "TopicData(topicId=" + this.topicId + ",partitions=" + this.partitions + ")";
    }
}

