/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.server.group.share.GroupTopicPartitionData;
import org.apache.kafka.server.group.share.PartitionFactory;
import org.apache.kafka.server.group.share.PartitionIdLeaderEpochData;
import org.apache.kafka.server.group.share.PersisterParameters;
import org.apache.kafka.server.group.share.TopicData;

public class ReadShareGroupStateParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData;

    private ReadShareGroupStateParameters(GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public static ReadShareGroupStateParameters from(ReadShareGroupStateRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionIdLeaderEpochData>(data.groupId(), data.topics().stream().map(readStateData -> new TopicData(readStateData.topicId(), readStateData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionIdLeaderEpochData(partitionData.partition(), partitionData.leaderEpoch())).collect(Collectors.toList()))).collect(Collectors.toList()))).build();
    }

    public String toString() {
        return "ReadShareGroupStateParameters(" + this.groupTopicPartitionData + ")";
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public ReadShareGroupStateParameters build() {
            return new ReadShareGroupStateParameters(this.groupTopicPartitionData);
        }
    }
}

