/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.server.group.share.PartitionAllData;
import org.apache.kafka.server.group.share.PartitionErrorData;
import org.apache.kafka.server.group.share.PartitionIdData;
import org.apache.kafka.server.group.share.PartitionIdLeaderEpochData;
import org.apache.kafka.server.group.share.PartitionStateBatchData;
import org.apache.kafka.server.group.share.PartitionStateData;
import org.apache.kafka.server.group.share.PartitionStateErrorData;
import org.apache.kafka.server.group.share.PersisterStateBatch;

public class PartitionData
implements PartitionIdData,
PartitionStateData,
PartitionErrorData,
PartitionStateErrorData,
PartitionStateBatchData,
PartitionIdLeaderEpochData,
PartitionAllData {
    private final int partition;
    private final int stateEpoch;
    private final long startOffset;
    private final short errorCode;
    private final String errorMessage;
    private final int leaderEpoch;
    private final List<PersisterStateBatch> stateBatches;

    public PartitionData(int partition, int stateEpoch, long startOffset, short errorCode, String errorMessage, int leaderEpoch, List<PersisterStateBatch> stateBatches) {
        this.partition = partition;
        this.stateEpoch = stateEpoch;
        this.startOffset = startOffset;
        this.errorCode = errorCode;
        this.leaderEpoch = leaderEpoch;
        this.errorMessage = errorMessage;
        this.stateBatches = stateBatches;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public int stateEpoch() {
        return this.stateEpoch;
    }

    @Override
    public long startOffset() {
        return this.startOffset;
    }

    @Override
    public short errorCode() {
        return this.errorCode;
    }

    @Override
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    @Override
    public List<PersisterStateBatch> stateBatches() {
        return this.stateBatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionData that = (PartitionData)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.stateEpoch, that.stateEpoch) && Objects.equals(this.startOffset, that.startOffset) && Objects.equals(this.errorCode, that.errorCode) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.leaderEpoch, that.leaderEpoch) && Objects.equals(this.stateBatches, that.stateBatches);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.stateEpoch, this.startOffset, this.errorCode, this.leaderEpoch, this.errorMessage, this.stateBatches);
    }

    public String toString() {
        return "PartitionData(partition=" + this.partition + ",stateEpoch=" + this.stateEpoch + ",startOffset=" + this.startOffset + ",errorCode=" + this.errorCode + ",errorMessage=" + this.errorMessage + ",leaderEpoch=" + this.leaderEpoch + ",stateBatches=" + this.stateBatches + ")";
    }

    public static class Builder {
        private int partition;
        private int stateEpoch;
        private long startOffset;
        private short errorCode;
        private String errorMessage;
        private int leaderEpoch;
        private List<PersisterStateBatch> stateBatches;

        public Builder setPartition(int partition) {
            this.partition = partition;
            return this;
        }

        public Builder setStateEpoch(int stateEpoch) {
            this.stateEpoch = stateEpoch;
            return this;
        }

        public Builder setStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public Builder setErrorCode(short errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder setLeaderEpoch(int leaderEpoch) {
            this.leaderEpoch = leaderEpoch;
            return this;
        }

        public Builder setStateBatches(List<PersisterStateBatch> stateBatches) {
            this.stateBatches = stateBatches;
            return this;
        }

        public PartitionData build() {
            return new PartitionData(this.partition, this.stateEpoch, this.startOffset, this.errorCode, this.errorMessage, this.leaderEpoch, this.stateBatches);
        }
    }
}

