/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.common.message.AssignReplicasToDirsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.common.TopicIdPartition;

public class AssignmentsHelper {
    public static AssignReplicasToDirsRequestData buildRequestData(int brokerId, long brokerEpoch, Map<TopicIdPartition, Uuid> assignment) {
        HashMap<Uuid, AssignReplicasToDirsRequestData.DirectoryData> directoryMap = new HashMap<Uuid, AssignReplicasToDirsRequestData.DirectoryData>();
        HashMap<Uuid, Map> topicMap = new HashMap<Uuid, Map>();
        for (Map.Entry<TopicIdPartition, Uuid> entry : assignment.entrySet()) {
            TopicIdPartition topicPartition = entry.getKey();
            Uuid directoryId = entry.getValue();
            AssignReplicasToDirsRequestData.DirectoryData directory = directoryMap.computeIfAbsent(directoryId, d -> new AssignReplicasToDirsRequestData.DirectoryData().setId(directoryId));
            AssignReplicasToDirsRequestData.TopicData topic = topicMap.computeIfAbsent(directoryId, d -> new HashMap()).computeIfAbsent(topicPartition.topicId(), topicId -> {
                AssignReplicasToDirsRequestData.TopicData data = new AssignReplicasToDirsRequestData.TopicData().setTopicId(topicId);
                directory.topics().add(data);
                return data;
            });
            AssignReplicasToDirsRequestData.PartitionData partition = new AssignReplicasToDirsRequestData.PartitionData().setPartitionIndex(topicPartition.partitionId());
            topic.partitions().add(partition);
        }
        return new AssignReplicasToDirsRequestData().setBrokerId(brokerId).setBrokerEpoch(brokerEpoch).setDirectories(new ArrayList(directoryMap.values()));
    }

    public static AssignReplicasToDirsResponseData buildResponseData(short errorCode, int throttleTimeMs, Map<Uuid, Map<TopicIdPartition, Errors>> errors) {
        HashMap<Uuid, AssignReplicasToDirsResponseData.DirectoryData> directoryMap = new HashMap<Uuid, AssignReplicasToDirsResponseData.DirectoryData>();
        HashMap<Uuid, Map> topicMap = new HashMap<Uuid, Map>();
        for (Map.Entry<Uuid, Map<TopicIdPartition, Errors>> dirEntry : errors.entrySet()) {
            Uuid directoryId = dirEntry.getKey();
            AssignReplicasToDirsResponseData.DirectoryData directory = directoryMap.computeIfAbsent(directoryId, d -> new AssignReplicasToDirsResponseData.DirectoryData().setId(directoryId));
            for (Map.Entry<TopicIdPartition, Errors> partitionEntry : dirEntry.getValue().entrySet()) {
                TopicIdPartition topicPartition = partitionEntry.getKey();
                Errors error = partitionEntry.getValue();
                AssignReplicasToDirsResponseData.TopicData topic = topicMap.computeIfAbsent(directoryId, d -> new HashMap()).computeIfAbsent(topicPartition.topicId(), topicId -> {
                    AssignReplicasToDirsResponseData.TopicData data = new AssignReplicasToDirsResponseData.TopicData().setTopicId(topicId);
                    directory.topics().add(data);
                    return data;
                });
                AssignReplicasToDirsResponseData.PartitionData partition = new AssignReplicasToDirsResponseData.PartitionData().setPartitionIndex(topicPartition.partitionId()).setErrorCode(error.code());
                topic.partitions().add(partition);
            }
        }
        return new AssignReplicasToDirsResponseData().setErrorCode(errorCode).setThrottleTimeMs(throttleTimeMs).setDirectories(new ArrayList(directoryMap.values()));
    }

    public static AssignReplicasToDirsRequestData normalize(AssignReplicasToDirsRequestData request) {
        request = request.duplicate();
        request.directories().sort(Comparator.comparing(AssignReplicasToDirsRequestData.DirectoryData::id));
        for (AssignReplicasToDirsRequestData.DirectoryData directory : request.directories()) {
            directory.topics().sort(Comparator.comparing(AssignReplicasToDirsRequestData.TopicData::topicId));
            for (AssignReplicasToDirsRequestData.TopicData topic : directory.topics()) {
                topic.partitions().sort(Comparator.comparing(AssignReplicasToDirsRequestData.PartitionData::partitionIndex));
            }
        }
        return request;
    }

    public static AssignReplicasToDirsResponseData normalize(AssignReplicasToDirsResponseData response) {
        response = response.duplicate();
        response.directories().sort(Comparator.comparing(AssignReplicasToDirsResponseData.DirectoryData::id));
        for (AssignReplicasToDirsResponseData.DirectoryData directory : response.directories()) {
            directory.topics().sort(Comparator.comparing(AssignReplicasToDirsResponseData.TopicData::topicId));
            for (AssignReplicasToDirsResponseData.TopicData topic : directory.topics()) {
                topic.partitions().sort(Comparator.comparing(AssignReplicasToDirsResponseData.PartitionData::partitionIndex));
            }
        }
        return response;
    }
}

