/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class StringSerializer
implements Serializer<String> {
    private Charset encoding = StandardCharsets.UTF_8;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.serializer.encoding" : "value.serializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("serializer.encoding");
        }
        if (encodingValue instanceof String) {
            String encodingName = (String)encodingValue;
            try {
                this.encoding = Charset.forName(encodingName);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new SerializationException("Unsupported encoding " + encodingName, e);
            }
        }
    }

    @Override
    public byte[] serialize(String topic, String data) {
        if (data == null) {
            return null;
        }
        return data.getBytes(this.encoding);
    }
}

