/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public abstract class CommitEvent
extends CompletableApplicationEvent<Void> {
    private final Map<TopicPartition, OffsetAndMetadata> offsets;

    protected CommitEvent(ApplicationEvent.Type type, Map<TopicPartition, OffsetAndMetadata> offsets, long deadlineMs) {
        super(type, deadlineMs);
        this.offsets = CommitEvent.validate(offsets);
    }

    private static Map<TopicPartition, OffsetAndMetadata> validate(Map<TopicPartition, OffsetAndMetadata> offsets) {
        for (OffsetAndMetadata offsetAndMetadata : offsets.values()) {
            if (offsetAndMetadata.offset() >= 0L) continue;
            throw new IllegalArgumentException("Invalid offset: " + offsetAndMetadata.offset());
        }
        return Collections.unmodifiableMap(offsets);
    }

    public Map<TopicPartition, OffsetAndMetadata> offsets() {
        return this.offsets;
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", offsets=" + this.offsets;
    }
}

