/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.GroupType;

public class ConsumerGroupListing {
    private final String groupId;
    private final boolean isSimpleConsumerGroup;
    private final Optional<ConsumerGroupState> state;
    private final Optional<GroupType> type;

    public ConsumerGroupListing(String groupId, boolean isSimpleConsumerGroup) {
        this(groupId, isSimpleConsumerGroup, Optional.empty(), Optional.empty());
    }

    public ConsumerGroupListing(String groupId, boolean isSimpleConsumerGroup, Optional<ConsumerGroupState> state) {
        this(groupId, isSimpleConsumerGroup, state, Optional.empty());
    }

    public ConsumerGroupListing(String groupId, boolean isSimpleConsumerGroup, Optional<ConsumerGroupState> state, Optional<GroupType> type) {
        this.groupId = groupId;
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        this.state = Objects.requireNonNull(state);
        this.type = Objects.requireNonNull(type);
    }

    public String groupId() {
        return this.groupId;
    }

    public boolean isSimpleConsumerGroup() {
        return this.isSimpleConsumerGroup;
    }

    public Optional<ConsumerGroupState> state() {
        return this.state;
    }

    public Optional<GroupType> type() {
        return this.type;
    }

    public String toString() {
        return "(groupId='" + this.groupId + '\'' + ", isSimpleConsumerGroup=" + this.isSimpleConsumerGroup + ", state=" + this.state + ", type=" + this.type + ')';
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.isSimpleConsumerGroup(), this.state, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsumerGroupListing)) {
            return false;
        }
        ConsumerGroupListing that = (ConsumerGroupListing)o;
        return this.isSimpleConsumerGroup() == that.isSimpleConsumerGroup() && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.state, that.state) && Objects.equals(this.type, that.type);
    }
}

