/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum RemotePartitionDeleteState {
    DELETE_PARTITION_MARKED(0),
    DELETE_PARTITION_STARTED(1),
    DELETE_PARTITION_FINISHED(2);

    private static final Map<Byte, RemotePartitionDeleteState> STATE_TYPES;
    private final byte id;

    private RemotePartitionDeleteState(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static RemotePartitionDeleteState forId(byte id) {
        return STATE_TYPES.get(id);
    }

    public static boolean isValidTransition(RemotePartitionDeleteState srcState, RemotePartitionDeleteState targetState) {
        Objects.requireNonNull(targetState, "targetState can not be null");
        if (srcState == null) {
            return targetState == DELETE_PARTITION_MARKED;
        }
        if (srcState == targetState) {
            return true;
        }
        if (srcState == DELETE_PARTITION_MARKED) {
            return targetState == DELETE_PARTITION_STARTED;
        }
        if (srcState == DELETE_PARTITION_STARTED) {
            return targetState == DELETE_PARTITION_FINISHED;
        }
        return false;
    }

    static {
        STATE_TYPES = Collections.unmodifiableMap(Arrays.stream(RemotePartitionDeleteState.values()).collect(Collectors.toMap(RemotePartitionDeleteState::id, Function.identity())));
    }
}

