/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import org.jruby.RubyIO;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOChannel;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

public class IOJavaAddons {
    @JRubyMethod(name={"to_input_stream", "to_inputstream"})
    public static IRubyObject to_inputstream(ThreadContext context, IRubyObject self2) {
        RubyIO io2 = (RubyIO)self2;
        io2.getOpenFile().checkReadable(context);
        return JavaUtil.convertJavaToUsableRubyObject(context.runtime, io2.getInStream());
    }

    @JRubyMethod(name={"to_output_stream", "to_outputstream"})
    public static IRubyObject to_outputstream(ThreadContext context, IRubyObject self2) {
        RubyIO io2 = (RubyIO)self2;
        io2.getOpenFile().checkWritable(context);
        return JavaUtil.convertJavaToUsableRubyObject(context.runtime, io2.getOutStream());
    }

    @JRubyMethod
    public static IRubyObject to_channel(ThreadContext context, IRubyObject self2) {
        RubyIO io2 = (RubyIO)self2;
        return JavaUtil.convertJavaToUsableRubyObject(context.runtime, io2.getChannel());
    }

    public static class AnyIO {
        @JRubyMethod(name={"to_input_stream", "to_inputstream"})
        public static IRubyObject any_to_inputstream(ThreadContext context, IRubyObject self2) {
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, new IOInputStream(self2));
        }

        @JRubyMethod(name={"to_output_stream", "to_outputstream"})
        public static IRubyObject any_to_outputstream(ThreadContext context, IRubyObject self2) {
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, new IOOutputStream(self2));
        }

        @JRubyMethod(name={"to_channel"})
        public static IRubyObject any_to_channel(ThreadContext context, IRubyObject self2) {
            IOChannel channel;
            if (self2.respondsTo("read")) {
                channel = self2.respondsTo("write") || self2.respondsTo("<<") ? new IOChannel.IOReadableWritableByteChannel(self2) : new IOChannel.IOReadableByteChannel(self2);
            } else if (self2.respondsTo("write") || self2.respondsTo("<<")) {
                channel = new IOChannel.IOWritableByteChannel(self2);
            } else {
                throw context.runtime.newTypeError(self2.inspect().toString() + " does not respond to any of read, write, or <<");
            }
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, channel);
        }
    }
}

