/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    private final Map<Signal, SignalHandler> original = new HashMap<Signal, SignalHandler>(4);
    private final Map<String, SignalHandler> fakeOriginal = new HashMap<String, SignalHandler>(4);
    private static final SignalHandler IGNORE = sig -> {};

    @Override
    public IRubyObject trap(ThreadContext context, IRubyObject recv2, IRubyObject blk, IRubyObject sig) {
        return this.trap(context, new JRubySignalHandler(context.runtime, blk, sig.toString()));
    }

    @Override
    public IRubyObject trap(ThreadContext context, BlockCallback blk, String sig) {
        return this.trap(context, new JRubySignalHandler(context.runtime, blk, sig));
    }

    private IRubyObject trap(ThreadContext context, JRubySignalHandler handler) {
        return this.trap(context, handler.signal, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject restorePlatformDefault(ThreadContext context, IRubyObject recv2, IRubyObject sig) {
        SignalHandler handler;
        Map<Object, SignalHandler> map2;
        try {
            map2 = this.original;
            synchronized (map2) {
                handler = this.original.get(new Signal(sig.toString()));
            }
        }
        catch (IllegalArgumentException e) {
            handler = null;
        }
        if (handler != null) {
            return this.trap(context, sig.toString(), handler);
        }
        map2 = this.fakeOriginal;
        synchronized (map2) {
            handler = this.fakeOriginal.remove(sig.toString());
        }
        return SunSignalFacade.getSignalResult(context, handler, true);
    }

    @Override
    public IRubyObject restoreOSDefault(ThreadContext context, IRubyObject recv2, IRubyObject sig) {
        return this.trap(context, sig.toString(), SignalHandler.SIG_DFL);
    }

    @Override
    public IRubyObject ignore(ThreadContext context, IRubyObject recv2, IRubyObject sig) {
        return this.trap(context, sig.toString(), IGNORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject trap(ThreadContext context, String signalName, SignalHandler handler) {
        boolean handled;
        SignalHandler oldHandler;
        try {
            Signal signal2 = new Signal(signalName);
            oldHandler = Signal.handle(signal2, handler);
            Map<Signal, SignalHandler> map2 = this.original;
            synchronized (map2) {
                if (!this.original.containsKey(signal2)) {
                    this.original.put(signal2, oldHandler);
                }
            }
            handled = true;
        }
        catch (IllegalArgumentException e) {
            oldHandler = this.fakeOriginal.get(signalName);
            Map<String, SignalHandler> map3 = this.fakeOriginal;
            synchronized (map3) {
                this.fakeOriginal.put(signalName, handler);
            }
            handled = signalName.equals("EXIT");
        }
        return SunSignalFacade.getSignalResult(context, oldHandler, handled);
    }

    private static IRubyObject getSignalResult(ThreadContext context, SignalHandler oldHandler, boolean handled) {
        RubyObject ret;
        RubyBoolean handledBoolean = Convert.asBoolean(context, handled);
        BlockCallback callback = null;
        if (oldHandler instanceof JRubySignalHandler) {
            JRubySignalHandler jsHandler = (JRubySignalHandler)oldHandler;
            if (jsHandler.blockCallback != null) {
                callback = jsHandler.blockCallback;
            } else {
                IRubyObject ret2 = jsHandler.block;
                return Create.newArray(context, ret2, (IRubyObject)handledBoolean);
            }
        }
        if (callback == null) {
            ret = oldHandler == SignalHandler.SIG_DFL ? Create.newString(context, "SYSTEM_DEFAULT") : (oldHandler == IGNORE ? Create.newString(context, "IGNORE") : Create.newString(context, "DEFAULT"));
        } else {
            Block block = CallBlock.newCallClosure(context, Access.getModule(context, "Signal"), Signature.NO_ARGUMENTS, callback);
            ret = RubyProc.newProc(context.runtime, block, Block.Type.PROC);
        }
        return RubyArray.newArrayMayCopy(context.runtime, ret, handledBoolean);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        private final Ruby runtime;
        private final IRubyObject block;
        private final String signal;
        private final BlockCallback blockCallback;

        public JRubySignalHandler(Ruby runtime2, IRubyObject block, String signal2) {
            this(runtime2, block, null, signal2);
        }

        public JRubySignalHandler(Ruby runtime2, BlockCallback callback, String signal2) {
            this(runtime2, null, callback, signal2);
        }

        private JRubySignalHandler(Ruby runtime2, IRubyObject block, BlockCallback callback, String signal2) {
            this.runtime = runtime2;
            this.block = block;
            this.blockCallback = callback;
            this.signal = signal2;
        }

        @Override
        public void handle(Signal signal2) {
            Signal.handle(new Signal(this.signal), this);
            ThreadContext context = this.runtime.getCurrentContext();
            GlobalVariables globalVariables = Access.globalVariables(context);
            IRubyObject oldExc = globalVariables.get("$!");
            try {
                RubyFixnum signum = Convert.asFixnum(context, signal2.getNumber());
                if (this.block != null) {
                    this.block.callMethod(context, "call", signum);
                } else {
                    this.blockCallback.call(context, (IRubyObject)signum, Block.NULL_BLOCK);
                }
            }
            catch (RaiseException e) {
                try {
                    this.runtime.getThread().callMethod(context, "main").callMethod(context, "raise", e.getException());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                globalVariables.set("$!", oldExc);
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
        }
    }
}

