/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.jcodings.Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.LineStubVisitor;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhileNode;
import org.jruby.lexer.ByteListLexerSource;
import org.jruby.lexer.GetsLexerSource;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.ParserType;
import org.jruby.parser.RubyParser;
import org.jruby.parser.RubyParserResult;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;

public class Parser {
    protected final Ruby runtime;

    public Parser(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public ParseResult parse(String fileName, int lineNumber, ByteList content, DynamicScope existingScope, ParserType type2) {
        return this.parse(new ByteListLexerSource(fileName, lineNumber, content, this.getLines(type2 == ParserType.EVAL, fileName, -1)), existingScope, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParseResult parse(String fileName, int lineNumber, InputStream in, Encoding encoding2, DynamicScope existingScope, ParserType type2) {
        RubyIO io2;
        RubyArray<?> list2 = this.getLines(type2 == ParserType.EVAL, fileName, -1);
        if (in instanceof LoadServiceResourceInputStream) {
            ByteList source2 = new ByteList(((LoadServiceResourceInputStream)in).getBytes(), encoding2);
            ByteListLexerSource lexerSource = new ByteListLexerSource(fileName, lineNumber, source2, list2);
            return this.parse(lexerSource, existingScope, type2);
        }
        boolean requiresClosing = false;
        if (in instanceof FileInputStream) {
            io2 = new RubyFile(this.runtime, fileName, ((FileInputStream)in).getChannel());
        } else {
            requiresClosing = true;
            io2 = RubyIO.newIO(this.runtime, Channels.newChannel(in));
        }
        GetsLexerSource lexerSource = new GetsLexerSource(fileName, lineNumber, io2, list2, encoding2);
        try {
            ParseResult parseResult = this.parse(lexerSource, existingScope, type2);
            return parseResult;
        }
        finally {
            ThreadContext context = this.runtime.getCurrentContext();
            if (requiresClosing && Access.objectClass(context).getConstantAt(context, "DATA") != io2) {
                io2.close();
            }
            this.runtime.setCurrentLine(0);
        }
    }

    private ParseResult parse(LexerSource lexerSource, DynamicScope existingScope, ParserType type2) {
        RubyParserResult result2;
        RubyParser parser = new RubyParser(this.runtime, lexerSource, existingScope, type2);
        try {
            result2 = parser.parse();
            if (parser.isEndSeen() && type2 == ParserType.MAIN) {
                this.runtime.defineDATA(lexerSource.getRemainingAsIO());
            }
        }
        catch (IOException e) {
            throw this.runtime.newSyntaxError("Problem reading source: " + String.valueOf(e), existingScope.getStaticScope().getFile());
        }
        catch (SyntaxException e) {
            throw this.runtime.newSyntaxError(e.getFile() + ":" + (e.getLine() + 1) + ": " + e.getMessage(), e.getFile());
        }
        this.runtime.getParserManager().getParserStats().addParsedBytes(lexerSource.getOffset());
        return (ParseResult)((Object)result2.getAST());
    }

    @Deprecated
    public Node parse(String file2, ByteList content, DynamicScope blockScope, ParserConfiguration configuration) {
        configuration.setDefaultEncoding(content.getEncoding());
        RubyArray<?> list2 = this.getLines(configuration.isEvalParse(), file2, -1);
        ByteListLexerSource lexerSource = new ByteListLexerSource(file2, configuration.getLineNumber(), content, list2);
        return this.parse(file2, lexerSource, blockScope, configuration);
    }

    @Deprecated
    public Node parse(String file2, byte[] content, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyArray<?> list2 = this.getLines(configuration.isEvalParse(), file2, -1);
        ByteList in = new ByteList(content, configuration.getDefaultEncoding());
        ByteListLexerSource lexerSource = new ByteListLexerSource(file2, configuration.getLineNumber(), in, list2);
        return this.parse(file2, lexerSource, blockScope, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Node parse(String file2, InputStream content, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyIO io2;
        if (content instanceof LoadServiceResourceInputStream) {
            return this.parse(file2, ((LoadServiceResourceInputStream)content).getBytes(), blockScope, configuration);
        }
        RubyArray<?> list2 = this.getLines(configuration.isEvalParse(), file2, -1);
        boolean requiresClosing = false;
        if (content instanceof FileInputStream) {
            io2 = new RubyFile(this.runtime, file2, ((FileInputStream)content).getChannel());
        } else {
            requiresClosing = true;
            io2 = RubyIO.newIO(this.runtime, Channels.newChannel(content));
        }
        GetsLexerSource lexerSource = new GetsLexerSource(file2, configuration.getLineNumber(), io2, list2, configuration.getDefaultEncoding());
        try {
            Node node = this.parse(file2, lexerSource, blockScope, configuration);
            return node;
        }
        finally {
            ThreadContext context = this.runtime.getCurrentContext();
            if (requiresClosing && Access.objectClass(context).getConstantAt(context, "DATA") != io2) {
                io2.close();
            }
            this.runtime.setCurrentLine(0);
        }
    }

    @Deprecated
    public Node parse(String file2, LexerSource lexerSource, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyParserResult result2;
        if (blockScope != null) {
            configuration.parseAsBlock(blockScope);
        }
        ParserType type2 = configuration.isEvalParse() ? ParserType.EVAL : (configuration.isInlineSource() ? ParserType.INLINE : (configuration.isSaveData() ? ParserType.MAIN : ParserType.NORMAL));
        RubyParser parser = new RubyParser(this.runtime, lexerSource, blockScope, type2);
        try {
            result2 = parser.parse();
            if (parser.lexer.isEndSeen() && configuration.isSaveData()) {
                IRubyObject verbose = this.runtime.getVerbose();
                this.runtime.setVerbose(this.runtime.getNil());
                this.runtime.getObject().defineConstant(this.runtime.getCurrentContext(), "DATA", lexerSource.getRemainingAsIO());
                this.runtime.setVerbose(verbose);
            }
        }
        catch (IOException e) {
            throw this.runtime.newSyntaxError("Problem reading source: " + String.valueOf(e), file2);
        }
        catch (SyntaxException e) {
            throw this.runtime.newSyntaxError(e.getFile() + ":" + (e.getLine() + 1) + ": " + e.getMessage(), e.getFile());
        }
        return result2.getAST();
    }

    protected RubyArray<?> getLines(boolean isEvalParse, String file2, int length2) {
        Ruby runtime2 = this.runtime;
        if (!(!isEvalParse || runtime2.isCoverageEnabled() && runtime2.getCoverageData().isEvalCovered())) {
            return null;
        }
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject scriptLines = Access.objectClass(context).getConstantAt(context, "SCRIPT_LINES__");
        if (!(scriptLines instanceof RubyHash)) {
            return null;
        }
        RubyHash hash2 = (RubyHash)scriptLines;
        RubyArray<?> list2 = length2 == -1 ? Create.newEmptyArray(context) : Create.allocArray(context, length2);
        hash2.op_aset(context, Create.newString(context, file2), list2);
        return list2;
    }

    public IRubyObject getLineStub(ThreadContext context, ParseResult result2, int lineCount) {
        RubyArray<?> lines2 = Create.newArray(context);
        LineStubVisitor lineVisitor = new LineStubVisitor(context.runtime, lines2);
        lineVisitor.visitRootNode((RootNode)result2);
        for (int i2 = 0; i2 <= lineCount - lines2.size(); ++i2) {
            lines2.append(context, context.nil);
        }
        return lines2;
    }

    public ParseResult addGetsLoop(Ruby runtime2, ParseResult oldRoot, boolean printing, boolean processLineEndings, boolean split2) {
        int line = oldRoot.getLine();
        BlockNode newBody = new BlockNode(line);
        if (processLineEndings) {
            RubySymbol dollarSlash = runtime2.newSymbol(CommonByteLists.DOLLAR_SLASH);
            newBody.add(new GlobalAsgnNode(line, runtime2.newSymbol(CommonByteLists.DOLLAR_BACKSLASH), new GlobalVarNode(line, dollarSlash)));
        }
        GlobalVarNode dollarUnderscore = new GlobalVarNode(line, runtime2.newSymbol("$_"));
        BlockNode whileBody = new BlockNode(line);
        newBody.add(new WhileNode(line, new VCallNode(line, runtime2.newSymbol("gets")), whileBody));
        if (processLineEndings) {
            whileBody.add(new CallNode(line, dollarUnderscore, runtime2.newSymbol("chomp!"), null, null, false));
        }
        if (split2) {
            whileBody.add(new GlobalAsgnNode(line, runtime2.newSymbol("$F"), new CallNode(line, dollarUnderscore, runtime2.newSymbol("split"), null, null, false)));
        }
        if (((RootNode)oldRoot).getBodyNode() instanceof BlockNode) {
            whileBody.addAll((BlockNode)((RootNode)oldRoot).getBodyNode());
        } else {
            whileBody.add(((RootNode)oldRoot).getBodyNode());
        }
        if (printing) {
            whileBody.add(new FCallNode(line, runtime2.newSymbol("print"), new ArrayNode(line, dollarUnderscore), null));
        }
        return new RootNode(line, oldRoot.getDynamicScope(), newBody, oldRoot.getFile());
    }
}

