/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.me.qmx.jitescript;

import java.util.ArrayList;
import org.jruby.me.qmx.jitescript.CodeBlock;
import org.jruby.me.qmx.jitescript.VisibleAnnotation;
import org.jruby.org.objectweb.asm.tree.AnnotationNode;
import org.jruby.org.objectweb.asm.tree.LocalVariableNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodDefinition {
    private final String methodName;
    private final int modifiers;
    private final String signature;
    private final CodeBlock methodBody;

    public MethodDefinition(String methodName, int modifiers, String signature, CodeBlock methodBody) {
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.signature = signature;
        this.methodBody = methodBody;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public CodeBlock getMethodBody() {
        return this.methodBody;
    }

    public String getSignature() {
        return this.signature;
    }

    public MethodNode getMethodNode() {
        MethodNode method2 = new MethodNode(this.getModifiers(), this.getMethodName(), this.getSignature(), null, null);
        method2.visibleAnnotations = new ArrayList<AnnotationNode>();
        method2.instructions.add(this.getMethodBody().getInstructionList());
        for (TryCatchBlockNode tryCatchBlockNode : this.getMethodBody().getTryCatchBlockList()) {
            method2.tryCatchBlocks.add(tryCatchBlockNode);
        }
        for (LocalVariableNode localVariableNode : this.getMethodBody().getLocalVariableList()) {
            method2.localVariables.add(localVariableNode);
        }
        for (VisibleAnnotation annotation : this.methodBody.getAnnotations()) {
            method2.visibleAnnotations.add(annotation.getNode());
        }
        return method2;
    }
}

