/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RegexpOptions;

public class BuildDynRegExpInstr
extends NOperandResultBaseInstr {
    private final RegexpOptions options;
    private final RECache reCache;

    private BuildDynRegExpInstr(Variable result2, Operand[] pieces, RegexpOptions options2, RECache reCache) {
        super(Operation.BUILD_DREGEXP, result2, pieces);
        this.options = options2;
        this.reCache = reCache;
    }

    public BuildDynRegExpInstr(Variable result2, Operand[] pieces, RegexpOptions options2) {
        super(Operation.BUILD_DREGEXP, result2, pieces);
        this.options = options2;
        this.reCache = new RECache();
    }

    public Operand[] getPieces() {
        return this.getOperands();
    }

    public RegexpOptions getOptions() {
        return this.options;
    }

    public RubyRegexp getRegexp() {
        return this.reCache.rubyRegexp;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"options: " + String.valueOf(this.options)};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildDynRegExpInstr(ii.getRenamedVariable(this.result), this.cloneOperands(ii), this.options, this.reCache);
    }

    private RubyString[] retrievePieces(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        Operand[] operands = this.getOperands();
        int length2 = operands.length;
        RubyString[] strings = new RubyString[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject value2 = (IRubyObject)operands[i2].retrieve(context, self2, currScope, currDynScope, temp);
            strings[i2] = value2.asString();
        }
        return strings;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getPieces());
        e.encode(this.getOptions().toEmbeddedOptions());
    }

    public static BuildDynRegExpInstr decode(IRReaderDecoder d) {
        return new BuildDynRegExpInstr(d.decodeVariable(), d.decodeOperandArray(), RegexpOptions.fromEmbeddedOptions(d.decodeInt()));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        boolean once = this.options.isOnce();
        if (!once || this.reCache.rubyRegexp == null || context.runtime.getKCode() != this.reCache.rubyRegexp.getKCode()) {
            RubyRegexp re = this.buildRegexp(context, currScope, currDynScope, self2, temp);
            if (!once) {
                return re;
            }
            this.reCache.updateCache(this.options.isOnce(), re);
        }
        return this.reCache.rubyRegexp;
    }

    private RubyRegexp buildRegexp(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject[] pieces = this.retrievePieces(context, self2, currScope, currDynScope, temp);
        RubyString pattern = RubyRegexp.preprocessDRegexp(context, this.options, pieces);
        RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, this.options);
        re.setLiteral();
        return re;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildDynRegExpInstr(this);
    }

    private static class RECache {
        private volatile RubyRegexp rubyRegexp;
        private static final AtomicReferenceFieldUpdater<RECache, RubyRegexp> UPDATER = AtomicReferenceFieldUpdater.newUpdater(RECache.class, RubyRegexp.class, "rubyRegexp");

        private RECache() {
        }

        public void updateCache(boolean isOnce, RubyRegexp re) {
            if (isOnce) {
                UPDATER.compareAndSet(this, null, re);
            } else {
                this.rubyRegexp = re;
            }
        }
    }
}

