/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.Getline;

public class RubyArgsFile
extends RubyObject {
    private static final Getline.Callback<RubyIO, IRubyObject> GETLINE = (context, self2, rs, limit2, chomp2, block) -> self2.getlineImpl(context, rs, limit2, chomp2);

    public RubyArgsFile(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public static void initArgsFile(ThreadContext context, RubyModule Enumerable, GlobalVariables globals) {
        RubyClass Object2 = Access.objectClass(context);
        RubyClass ARGF = (RubyClass)((RubyModule)Define.defineClass(context, "ARGFClass", Object2, RubyArgsFile::new).include(context, Enumerable)).defineMethods(context, RubyArgsFile.class);
        IRubyObject argsFile = ARGF.newInstance(context, new IRubyObject[]{null}, null);
        context.runtime.setArgsFile(argsFile);
        globals.defineReadonly("$<", new ArgsFileAccessor(context.runtime), GlobalVariable.Scope.GLOBAL);
        Object2.defineConstant(context, "ARGF", argsFile);
        globals.defineReadonly("$FILENAME", new ValueAccessor(Create.newString(context, "-")), GlobalVariable.Scope.GLOBAL);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        RubyArray argv2 = args2.length == 1 && args2[0] == null ? Access.objectClass(context).getConstant(context, "ARGV").convertToArray() : Create.newArray(context, args2);
        IRubyObject argsFile = Access.argsFile(context);
        if (argsFile == null) {
            this.dataWrapStruct(new ArgsFileData(context.runtime, argv2));
        } else {
            ArgsFileData data2 = (ArgsFileData)argsFile.dataGetStruct();
            this.dataWrapStruct(data2);
            data2.setArgs(argv2);
        }
        return this;
    }

    @Deprecated
    public static void setCurrentLineNumber(IRubyObject recv2, int newLineNumber) {
        ((RubyBasicObject)recv2).getCurrentContext().runtime.setCurrentLine(newLineNumber);
    }

    @JRubyMethod
    public static IRubyObject inplace_mode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (data2.inPlace == null) {
            return context.nil;
        }
        if (data2.inPlace.isNil()) {
            return context.nil;
        }
        return data2.inPlace.dup();
    }

    @JRubyMethod(name={"inplace_mode="})
    public static IRubyObject inplace_mode_set(ThreadContext context, IRubyObject recv2, IRubyObject test2) {
        return RubyArgsFile.setInplaceMode(context, recv2, test2);
    }

    private static IRubyObject setInplaceMode(ThreadContext context, IRubyObject recv2, IRubyObject test2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (test2.isNil()) {
            data2.inPlace = context.nil;
        } else if (!test2.isTrue()) {
            data2.inPlace = context.fals;
        } else if ((test2 = TypeConverter.convertToType(test2, Access.stringClass(context), "to_str", false)).isNil() || ((RubyString)test2).isEmpty()) {
            data2.inPlace = context.nil;
        } else {
            StringSupport.checkStringSafety(context.runtime, test2);
            test2.setFrozen(true);
            data2.inPlace = test2;
        }
        return recv2;
    }

    @JRubyMethod(name={"inplace_mode="})
    public IRubyObject inplace_mode_set(ThreadContext context, IRubyObject test2) {
        return RubyArgsFile.setInplaceMode(context, this, test2);
    }

    @JRubyMethod(name={"argv"})
    public static IRubyObject argv(ThreadContext context, IRubyObject recv2) {
        return ArgsFileData.getArgsFileData((Ruby)context.runtime).argv;
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream").fileno(context);
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream");
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").set_encoding(context, encoding2);
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2, IRubyObject internalEncoding) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").set_encoding(context, encoding2, internalEncoding);
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2, IRubyObject internalEncoding, IRubyObject options2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").set_encoding(context, encoding2, internalEncoding, options2);
    }

    @JRubyMethod
    public static IRubyObject internal_encoding(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").internal_encoding(context);
    }

    @JRubyMethod
    public static IRubyObject external_encoding(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set encoding").external_encoding(context);
    }

    private static IRubyObject argf_getline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        int callInfo = ThreadContext.resetCallInfo(context);
        boolean keywords = (callInfo & 2) != 0;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        while (true) {
            if (!data2.next_argv(context)) {
                return context.nil;
            }
            RubyIO currentFile = (RubyIO)data2.currentFile;
            if (RubyArgsFile.isGenericInput(context, data2)) {
                context.callInfo = callInfo;
                line = data2.currentFile.callMethod(context, "gets", args2);
                break;
            }
            line = args2.length == 0 && context.runtime.getRecordSeparatorVar().get() == Access.globalVariables(context).getDefaultSeparator() ? currentFile.gets(context) : Getline.getlineCall(context, GETLINE, currentFile, currentFile.getReadEncoding(), keywords, args2);
            if (!line.isNil() || data2.next_p == Next.Stream) break;
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = Next.NextFile;
        }
        return line;
    }

    private static boolean isGenericInput(ThreadContext context, ArgsFileData data2) {
        return data2.currentFile == Access.globalVariables(context).get("$stdin") && !(data2.currentFile instanceof RubyFile);
    }

    @JRubyMethod(name={"gets"}, optional=1, keywords=true, checkArity=false, writes={FrameField.LASTLINE})
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return context.setLastLine(RubyArgsFile.argf_getline(context, recv2, args2));
    }

    @JRubyMethod(name={"readline"}, optional=1, keywords=true, checkArity=false, writes={FrameField.LASTLINE})
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyArgsFile.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(optional=1, keywords=true, checkArity=false)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        Arity.checkArgumentCount(context, args2, 0, 1);
        int callInfo = context.callInfo;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.next_argv(context)) {
            return Create.newEmptyArray(context);
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "readlines", args2);
        }
        RubyArray<?> ary = Create.newArray(context);
        while (!(line = RubyArgsFile.argfGetlineLoopWithKeywords(context, recv2, args2, callInfo)).isNil()) {
            ary.append(context, line);
        }
        return ary;
    }

    private static IRubyObject argfGetlineLoopWithKeywords(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, int callInfo) {
        context.callInfo = callInfo;
        return RubyArgsFile.argf_getline(context, recv2, args2);
    }

    @JRubyMethod(optional=1, checkArity=false)
    public static IRubyObject to_a(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        Arity.checkArgumentCount(context, args2, 0, 1);
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.next_argv(context)) {
            return Create.newEmptyArray(context);
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "to_a", args2);
        }
        RubyArray<?> ary = Create.newArray(context);
        while ((line = RubyArgsFile.argf_getline(context, recv2, args2)) != context.nil) {
            ary.append(context, line);
        }
        return ary;
    }

    @JRubyMethod
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject bt;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_byte");
        }
        while ((bt = RubyArgsFile.getc(context, recv2)) != context.nil) {
            block.yield(context, bt);
        }
        return recv2;
    }

    @JRubyMethod
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_byte");
    }

    @JRubyMethod(optional=1, checkArity=false)
    public static IRubyObject bytes(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "bytes");
    }

    @JRubyMethod
    public static IRubyObject each_char(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_char");
    }

    @JRubyMethod
    public static IRubyObject chars(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "chars");
    }

    public static IRubyObject each_charCommon(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject ch;
        Ruby runtime2 = context.runtime;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(runtime2);
        while ((ch = RubyArgsFile.getc(context, recv2)) != context.nil) {
            boolean cont = true;
            while (cont) {
                cont = false;
                byte c = Convert.toByte(context, ch);
                int n = runtime2.getKCode().getEncoding().length(c);
                IRubyObject file2 = data2.currentFile;
                RubyString str = runtime2.newString();
                str.cat(c);
                while (--n > 0) {
                    ch = RubyArgsFile.getc(context, recv2);
                    if (ch == context.nil) {
                        block.yield(context, str);
                        return recv2;
                    }
                    if (data2.currentFile != file2) {
                        block.yield(context, str);
                        cont = true;
                        continue;
                    }
                    c = Convert.toByte(context, ch);
                    str.cat(c);
                }
                block.yield(context, str);
            }
        }
        return recv2;
    }

    @JRubyMethod
    public static IRubyObject each_codepoint(ThreadContext context, IRubyObject recv2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_codepoint");
        }
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        CallSite each_codepoint2 = RubyArgsFile.sites((ThreadContext)context).each_codepoint;
        while (data2.next_argv(context)) {
            each_codepoint2.call(context, recv2, data2.currentFile, block);
            data2.next_p = Next.NextFile;
        }
        return recv2;
    }

    @Deprecated(since="9.4-")
    public static IRubyObject codepoints(ThreadContext context, IRubyObject recv2, Block block) {
        Warn.warn(context, "ARGF#codepoints is deprecated; use #each_codepoint instead");
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line");
        }
        return RubyArgsFile.each_codepoint(context, recv2, block);
    }

    @JRubyMethod(name={"each_line"}, optional=1, keywords=true, checkArity=false)
    public static IRubyObject each_line(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject str;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line", args2);
        }
        Arity.checkArgumentCount(context, args2, 0, 1);
        int callInfo = context.callInfo;
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.next_argv(context)) {
            return context.nil;
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            if (!data2.next_argv(context)) {
                return recv2;
            }
            data2.currentFile.callMethod(context, "each", NULL_ARRAY, block);
            data2.next_p = Next.NextFile;
        }
        while ((str = RubyArgsFile.argfGetlineLoopWithKeywords(context, recv2, args2, callInfo)) != context.nil) {
            block.yield(context, str);
        }
        return recv2;
    }

    @Deprecated(since="10.0")
    public static IRubyObject lines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line");
        }
        return RubyArgsFile.each_line(context, recv2, args2, block);
    }

    @JRubyMethod(name={"each"}, optional=1, checkArity=false)
    public static IRubyObject each(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each", args2);
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.next_argv(context);
        return data2.currentFile;
    }

    @Deprecated(since="10.0")
    public static IRubyObject skip(IRubyObject recv2) {
        return RubyArgsFile.skip(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (data2.inited && data2.next_p == Next.SameFile) {
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = Next.NextFile;
        }
        return recv2;
    }

    public static void argf_close(ThreadContext context, IRubyObject file2) {
        if (file2 instanceof RubyIO) {
            ((RubyIO)file2).rbIoClose(context);
        } else {
            file2.callMethod(context, "close");
        }
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.next_argv(context);
        if (data2.currentFile == Access.globalVariables(context).get("$stdin")) {
            return recv2;
        }
        RubyArgsFile.argf_close(context, data2.currentFile);
        if (data2.next_p != Next.Stream) {
            data2.next_p = Next.NextFile;
        }
        context.runtime.setCurrentLine(0);
        return recv2;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.next_argv(context);
        return Convert.asBoolean(context, RubyArgsFile.isClosed(context, data2.currentFile));
    }

    private static boolean isClosed(ThreadContext context, IRubyObject currentFile) {
        if (!(currentFile instanceof RubyIO)) {
            return currentFile.callMethod(context, "closed?").isTrue();
        }
        return ((RubyIO)currentFile).closed_p(context).isTrue();
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        data2.binmode = true;
        if (data2.currentFile != context.nil) {
            ((RubyIO)data2.currentFile).binmode(context);
        }
        return recv2;
    }

    @JRubyMethod(name={"binmode?"})
    public static IRubyObject op_binmode(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream").op_binmode(context);
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, context.runtime.getCurrentLine());
    }

    @JRubyMethod(name={"lineno="})
    public static IRubyObject lineno_set(ThreadContext context, IRubyObject recv2, IRubyObject line) {
        context.runtime.setCurrentLine(Convert.toInt(context, line));
        return context.nil;
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to tell").pos(context);
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(ThreadContext context, IRubyObject recv2) {
        RubyIO currentFile = RubyArgsFile.getCurrentDataFile(context, "no stream to rewind");
        RubyFixnum retVal = currentFile.rewind(context);
        currentFile.lineno_set(context, Convert.asFixnum(context, 0));
        return retVal;
    }

    @JRubyMethod(name={"eof"})
    public static IRubyObject eof(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.inited) {
            return context.tru;
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "eof");
        }
        return ((RubyIO)data2.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"eof?"})
    public static IRubyObject eof_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.inited) {
            return context.tru;
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "eof?");
        }
        return ((RubyIO)data2.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"pos="})
    public static IRubyObject set_pos(ThreadContext context, IRubyObject recv2, IRubyObject offset2) {
        return RubyArgsFile.getCurrentDataFile(context, "no stream to set position").pos_set(context, offset2);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1, checkArity=false)
    public static IRubyObject seek(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        return RubyArgsFile.getCurrentDataFile(context, "no stream to seek").seek(context, args2);
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getc(context, recv2);
        if (c == context.nil) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public static IRubyObject getbyte(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        while (data2.next_argv(context)) {
            IRubyObject bt = data2.currentFile instanceof RubyFile ? ((RubyIO)data2.currentFile).getbyte(context) : data2.currentFile.callMethod(context, "getbyte");
            if (bt != context.nil) {
                return bt;
            }
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = Next.NextFile;
        }
        return context.nil;
    }

    @JRubyMethod(required=1, optional=2, checkArity=false)
    public static IRubyObject read_nonblock(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 3);
        return RubyArgsFile.getPartial(context, recv2, args2, true);
    }

    @JRubyMethod(required=1, optional=1, checkArity=false)
    public static IRubyObject readpartial(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        return RubyArgsFile.getPartial(context, recv2, args2, false);
    }

    private static IRubyObject getPartial(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, boolean nonBlocking) {
        ArgsFileData data2;
        Ruby runtime2 = context.runtime;
        boolean noException = false;
        RubyString str = null;
        if (args2.length > 1) {
            IRubyObject opts = TypeConverter.checkHashType(runtime2, args2[args2.length - 1]);
            if (opts != context.nil && context.fals == ((RubyHash)opts).op_aref(context, Convert.asSymbol(context, "exception"))) {
                noException = true;
            }
            if ((args2.length > 2 || opts == context.nil) && args2[1] != context.nil) {
                args2[1] = args2[1].convertToString();
                str = (RubyString)args2[1];
            }
        }
        if (!(data2 = ArgsFileData.getArgsFileData(runtime2)).next_argv(context)) {
            if (str != null) {
                str.clear(context);
            }
            return RubyIO.nonblockEOF(runtime2, noException);
        }
        IRubyObject res = ((RubyIO)data2.currentFile).getPartial(context, args2, nonBlocking, noException);
        if (res != context.nil) {
            return res;
        }
        if (data2.next_p == Next.Stream) {
            return RubyIO.nonblockEOF(runtime2, noException);
        }
        RubyArgsFile.argf_close(context, data2.currentFile);
        data2.next_p = Next.NextFile;
        if (data2.argv.isEmpty()) {
            return RubyIO.nonblockEOF(runtime2, noException);
        }
        return args2.length > 1 && args2[1] instanceof RubyString ? args2[1] : Create.newEmptyString(context);
    }

    @JRubyMethod
    public static IRubyObject readbyte(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getbyte(context, recv2);
        if (c.isNil()) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        while (data2.next_argv(context)) {
            IRubyObject bt = data2.currentFile instanceof RubyFile ? ((RubyIO)data2.currentFile).getbyte(context) : data2.currentFile.callMethod(context, "getc");
            if (bt != context.nil) {
                return bt;
            }
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = Next.NextFile;
        }
        return context.nil;
    }

    @JRubyMethod(name={"read"}, optional=2, checkArity=false)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject str;
        IRubyObject length2;
        int argc = Arity.checkArgumentCount(context, args2, 0, 2);
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        long len = 0L;
        IRubyObject nil = context.nil;
        if (argc > 0) {
            length2 = args2[0];
            str = argc > 1 ? args2[1] : nil;
        } else {
            str = length2 = nil;
        }
        if (length2 != nil) {
            len = Convert.toLong(context, length2);
        }
        if (str != nil) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args2[1] = nil;
        }
        while (true) {
            int strLen;
            IRubyObject tmp;
            if (!data2.next_argv(context)) {
                return str;
            }
            IRubyObject iRubyObject = data2.currentFile;
            if (iRubyObject instanceof RubyIO) {
                RubyIO file2 = (RubyIO)iRubyObject;
                v0 = file2.read(context, args2);
            } else {
                v0 = tmp = data2.currentFile.callMethod(context, "read", args2);
            }
            if (str == nil) {
                str = tmp;
            } else if (tmp != nil) {
                ((RubyString)str).append(tmp);
            }
            if (tmp == nil || length2 == nil) {
                if (data2.next_p == Next.Stream) break;
                RubyArgsFile.argf_close(context, data2.currentFile);
                data2.next_p = Next.NextFile;
                continue;
            }
            if (argc < 1 || (long)(strLen = ((RubyString)str).getByteList().length()) >= len) break;
            args2[0] = Convert.asFixnum(context, len - (long)strLen);
        }
        return str;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static IRubyObject filename(ThreadContext context, IRubyObject recv2) {
        ArgsFileData.getArgsFileData(context.runtime).next_argv(context);
        return Access.globalVariables(context).get("$FILENAME");
    }

    @Deprecated(since="10.0")
    public static IRubyObject to_s(IRubyObject recv2) {
        return RubyArgsFile.to_s(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public static IRubyObject to_s(ThreadContext context, IRubyObject recv2) {
        return Create.newString(context, "ARGF");
    }

    @JRubyMethod(name={"write"}, rest=true)
    public static IRubyObject write(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.writev(context, (IRubyObject)RubyArgsFile.argfWriteIO(context), args2);
    }

    @JRubyMethod(name={"write"})
    public static IRubyObject write(ThreadContext context, IRubyObject recv2) {
        return RubyIO.writev(context, RubyArgsFile.argfWriteIO(context));
    }

    @JRubyMethod(name={"write"})
    public static IRubyObject write(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyIO.writev(context, (IRubyObject)RubyArgsFile.argfWriteIO(context), arg0);
    }

    @JRubyMethod(name={"write"})
    public static IRubyObject write(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.writev(context, RubyArgsFile.argfWriteIO(context), arg0, arg1);
    }

    @JRubyMethod(name={"write"})
    public static IRubyObject write(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.writev(context, RubyArgsFile.argfWriteIO(context), arg0, arg1, arg2);
    }

    @JRubyMethod(name={"print"}, rest=true)
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.print(context, recv2, args2);
    }

    @JRubyMethod(name={"print"})
    public static IRubyObject print(ThreadContext context, IRubyObject recv2) {
        return RubyIO.print0(context, recv2);
    }

    @JRubyMethod(name={"print"})
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyIO.print1(context, recv2, arg0);
    }

    @JRubyMethod(name={"print"})
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.print2(context, recv2, arg0, arg1);
    }

    @JRubyMethod(name={"print"})
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.print3(context, recv2, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"printf"}, rest=true)
    public static IRubyObject printf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.printf(context, recv2, args2);
    }

    @JRubyMethod(name={"putc"})
    public static IRubyObject putc(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyIO.putc(context, recv2, arg0);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.puts(context, recv2, args2);
    }

    @JRubyMethod(name={"puts"})
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2) {
        return RubyIO.puts0(context, recv2);
    }

    @JRubyMethod(name={"puts"})
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyIO.puts1(context, recv2, arg0);
    }

    @JRubyMethod(name={"puts"})
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.puts2(context, recv2, arg0, arg1);
    }

    @JRubyMethod(name={"puts"})
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.puts3(context, recv2, arg0, arg1, arg2);
    }

    private static RubyIO getCurrentDataFile(ThreadContext context, String errorMessage) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.next_argv(context)) {
            throw Error.argumentError(context, errorMessage);
        }
        return (RubyIO)data2.currentFile;
    }

    private static RubyIO argfWriteIO(ThreadContext context) {
        ArgsFileData data2 = ArgsFileData.getArgsFileData(context.runtime);
        if (!data2.next_argv(context)) {
            throw Error.argumentError(context, "not opened for writing");
        }
        return ((RubyIO)data2.currentFile).GetWriteIO();
    }

    private static JavaSites.ArgfSites sites(ThreadContext context) {
        return context.sites.Argf;
    }

    private static class ArgsFileAccessor
    implements IAccessor {
        private final Ruby runtime;

        ArgsFileAccessor(Ruby runtime2) {
            this.runtime = runtime2;
        }

        @Override
        public IRubyObject getValue() {
            return this.runtime.getArgsFile();
        }

        @Override
        public IRubyObject setValue(IRubyObject newValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static final class ArgsFileData {
        private final Ruby runtime;
        private RubyArray argv;
        public IRubyObject currentFile;
        private boolean inited = false;
        public Next next_p = Next.NextFile;
        public boolean binmode = false;
        private IRubyObject inPlace;

        public ArgsFileData(Ruby runtime2, RubyArray argv2) {
            this.runtime = runtime2;
            this.setArgs(argv2);
            this.currentFile = runtime2.getNil();
        }

        @Deprecated
        public void setCurrentLineNumber(Ruby runtime2, int linenumber) {
            runtime2.setCurrentLine(linenumber);
        }

        void setArgs(RubyArray argv2) {
            this.inited = false;
            this.argv = argv2;
            this.inPlace = this.runtime.getFalse();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean next_argv(ThreadContext context) {
            if (!this.inited) {
                this.next_p = this.argv.getLength() > 0 ? Next.NextFile : Next.Stream;
                this.inited = true;
                this.runtime.setCurrentLine(0);
            } else if (this.argv.isNil()) {
                this.next_p = Next.Stream;
            } else if (this.next_p == Next.Stream && this.argv.getLength() > 0) {
                this.next_p = Next.NextFile;
            }
            GlobalVariables globalVariables = Access.globalVariables(context);
            GlobalVariable $FILENAME = globalVariables.getVariable("$FILENAME");
            if (this.next_p != Next.NextFile) {
                if (this.next_p != Next.Stream) return true;
                this.currentFile = globalVariables.get("$stdin");
                if (ArgsFileData.filenameEqlDash((RubyString)$FILENAME.getAccessor().getValue())) return true;
                $FILENAME.forceValue(Create.newString(context, "-"));
                return true;
            }
            if (this.argv.getLength() <= 0) {
                this.next_p = Next.NextFile;
                return false;
            }
            RubyString filename2 = TypeConverter.convertToType(this.argv.shift(context), Access.stringClass(context), "to_path").convertToString();
            StringSupport.checkStringSafety(this.runtime, filename2);
            if (!filename2.op_equal(context, $FILENAME.getAccessor().getValue()).isTrue()) {
                $FILENAME.forceValue(filename2);
            }
            if (ArgsFileData.filenameEqlDash(filename2)) {
                this.currentFile = globalVariables.get("$stdin");
            } else {
                RubyIO currentFileIO = (RubyIO)RubyFile.open(context, Access.fileClass(context), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                this.currentFile = currentFileIO;
                String extension = null;
                if (this.inPlace.isTrue()) {
                    extension = this.inPlace.asJavaString();
                }
                if (extension == null) {
                    extension = Access.instanceConfig(context).getInPlaceBackupExtension();
                }
                if (extension != null) {
                    if (Platform.IS_WINDOWS) {
                        this.inplaceEditWindows(context, currentFileIO, filename2.asJavaString(), extension);
                    } else {
                        this.inplaceEdit(context, currentFileIO, filename2.asJavaString(), extension);
                    }
                }
                if (this.binmode) {
                    currentFileIO.binmode(context);
                }
            }
            this.next_p = Next.SameFile;
            return true;
        }

        private static boolean filenameEqlDash(RubyString filename2) {
            ByteList filenameBytes = filename2.getByteList();
            return filenameBytes.length() == 1 && filenameBytes.get(0) == 45;
        }

        public static ArgsFileData getArgsFileData(Ruby runtime2) {
            return (ArgsFileData)runtime2.getArgsFile().dataGetStruct();
        }

        @Deprecated
        public static ArgsFileData getDataFrom(IRubyObject recv2) {
            return ArgsFileData.getArgsFileData(((RubyBasicObject)recv2).getCurrentContext().runtime);
        }

        private void createNewFile(File file2) {
            try {
                file2.createNewFile();
            }
            catch (IOException ex) {
                throw this.runtime.newIOErrorFromException(ex);
            }
        }

        private void inplaceEditWindows(ThreadContext context, RubyIO argfIO, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            if (extension.isEmpty()) {
                throw this.runtime.newIOError("Windows doesn't support inplace editing without a backup");
            }
            String backup = filename2 + extension;
            File backupFile = new File(backup);
            ((RubyIO)this.currentFile).close();
            backupFile.delete();
            file2.renameTo(backupFile);
            this.currentFile = RubyFile.open(context, Access.fileClass(context), new IRubyObject[]{Create.newString(context, backup)}, Block.NULL_BLOCK);
            this.createNewFile(file2);
            IRubyObject writeIO = RubyFile.open(context, Access.fileClass(context), new IRubyObject[]{Create.newString(context, filename2), Create.newString(context, "w")}, Block.NULL_BLOCK);
            argfIO.getOpenFile().tiedIOForWriting = (RubyIO)writeIO;
            Access.globalVariables(context).set("$stdout", writeIO);
        }

        private void inplaceEdit(ThreadContext context, RubyIO argfIO, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            POSIX posix = context.runtime.getPosix();
            FileStat stat2 = posix.stat(filename2);
            if (!extension.isEmpty()) {
                file2.renameTo(new File(filename2 + extension));
            } else {
                file2.delete();
            }
            this.createNewFile(file2);
            posix.chmod(filename2, stat2.mode());
            posix.chown(filename2, stat2.uid(), stat2.gid());
            IRubyObject writeIO = RubyFile.open(context, Access.fileClass(context), new IRubyObject[]{Create.newString(context, filename2), Create.newString(context, "w")}, Block.NULL_BLOCK);
            argfIO.getOpenFile().tiedIOForWriting = (RubyIO)writeIO;
            Access.globalVariables(context).set("$stdout", (RubyIO)writeIO);
        }

        public boolean isCurrentFile(RubyIO io2) {
            return this.currentFile == io2;
        }
    }

    public static enum Next {
        Stream,
        SameFile,
        NextFile;

    }
}

