/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class TileSourceDisplaySettings
implements SessionAwareReadApply {
    public static final String AUTO_LOAD = "automatic-downloading";
    public static final String AUTO_ZOOM = "automatically-change-resolution";
    private static final String SHOW_ERRORS = "show-errors";
    private static final String DISPLACEMENT = "displacement";
    private static final String PREFERENCE_PREFIX = "imagery.generic";
    public static final BooleanProperty PROP_AUTO_LOAD = new BooleanProperty("imagery.generic.default_autoload", true);
    public static final BooleanProperty PROP_AUTO_ZOOM = new BooleanProperty("imagery.generic.default_autozoom", true);
    private boolean autoZoom;
    private boolean autoLoad;
    private boolean showErrors;
    private OffsetBookmark previousOffsetBookmark;
    private OffsetBookmark offsetBookmark;
    private EastNorth displacement = EastNorth.ZERO;
    private final CopyOnWriteArrayList<DisplaySettingsChangeListener> listeners = new CopyOnWriteArrayList();

    public TileSourceDisplaySettings() {
        this(new String[]{PREFERENCE_PREFIX});
    }

    public TileSourceDisplaySettings(String preferencePrefix) {
        this(PREFERENCE_PREFIX, preferencePrefix);
    }

    private TileSourceDisplaySettings(String ... prefixes) {
        this.autoZoom = TileSourceDisplaySettings.getProperty(prefixes, "default_autozoom", (Boolean)PROP_AUTO_ZOOM.getDefaultValue());
        this.autoLoad = TileSourceDisplaySettings.getProperty(prefixes, "default_autoload", (Boolean)PROP_AUTO_LOAD.getDefaultValue());
        this.showErrors = TileSourceDisplaySettings.getProperty(prefixes, "default_showerrors", Boolean.TRUE);
    }

    private static boolean getProperty(String[] prefixes, String name, Boolean def) {
        boolean value = true;
        for (String p : prefixes) {
            String key = p + "." + name;
            boolean currentValue = Config.getPref().getBoolean(key, true);
            if (Config.getPref().get(key, def.toString()).isEmpty()) continue;
            value = currentValue;
        }
        return value;
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public void setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
        this.fireSettingsChange(AUTO_ZOOM);
    }

    public boolean isAutoLoad() {
        return this.autoLoad;
    }

    public void setAutoLoad(boolean autoLoad) {
        this.autoLoad = autoLoad;
        this.fireSettingsChange(AUTO_LOAD);
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
        this.fireSettingsChange(SHOW_ERRORS);
    }

    public double getDx() {
        return this.getDisplacement().east();
    }

    public double getDy() {
        return this.getDisplacement().north();
    }

    public EastNorth getDisplacement() {
        return this.displacement;
    }

    public String getDisplacementString(Locale locale) {
        int precision = ProjectionRegistry.getProjection().getDefaultZoomInPPD() >= 1.0 ? 2 : 7;
        return String.format(locale, "%1." + precision + "f; %1." + precision + "f", this.getDx(), this.getDy());
    }

    public void setOffsetBookmark(OffsetBookmark offsetBookmark) {
        if (this.offsetBookmark != null) {
            this.previousOffsetBookmark = this.offsetBookmark;
        }
        this.offsetBookmark = offsetBookmark;
        if (offsetBookmark == null) {
            this.setDisplacement(EastNorth.ZERO);
        } else {
            this.setDisplacement(offsetBookmark.getDisplacement(ProjectionRegistry.getProjection()));
        }
    }

    public OffsetBookmark getOffsetBookmark() {
        return this.offsetBookmark;
    }

    public OffsetBookmark getPreviousOffsetBookmark() {
        return this.previousOffsetBookmark;
    }

    private void setDisplacement(EastNorth displacement) {
        CheckParameterUtil.ensureThat(displacement.isValid(), () -> displacement + " invalid");
        this.displacement = displacement;
        this.fireSettingsChange(DISPLACEMENT);
    }

    private void fireSettingsChange(String changedSetting) {
        DisplaySettingsChangeEvent e = new DisplaySettingsChangeEvent(changedSetting);
        for (DisplaySettingsChangeListener l : this.listeners) {
            l.displaySettingsChanged(e);
        }
    }

    public void addSettingsChangeListener(DisplaySettingsChangeListener l) {
        this.listeners.add(l);
    }

    public void removeSettingsChangeListener(DisplaySettingsChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(AUTO_LOAD, Boolean.toString(this.autoLoad));
        data.put(AUTO_ZOOM, Boolean.toString(this.autoZoom));
        data.put(SHOW_ERRORS, Boolean.toString(this.showErrors));
        return data;
    }

    @Override
    public void applyFromPropertiesMap(Map<String, String> data) {
        try {
            String doShowErrors;
            String doAutoZoom;
            String doAutoLoad = data.get(AUTO_LOAD);
            if (doAutoLoad != null) {
                this.setAutoLoad(Boolean.parseBoolean(doAutoLoad));
            }
            if ((doAutoZoom = data.get(AUTO_ZOOM)) != null) {
                this.setAutoZoom(Boolean.parseBoolean(doAutoZoom));
            }
            if ((doShowErrors = data.get(SHOW_ERRORS)) != null) {
                this.setShowErrors(Boolean.parseBoolean(doShowErrors));
            }
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("data", data);
        }
    }

    public int hashCode() {
        return Objects.hash(this.autoLoad, this.autoZoom, this.showErrors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TileSourceDisplaySettings other = (TileSourceDisplaySettings)obj;
        return this.autoLoad == other.autoLoad && this.autoZoom == other.autoZoom && this.showErrors == other.showErrors;
    }

    public String toString() {
        return "TileSourceDisplaySettings [autoZoom=" + this.autoZoom + ", autoLoad=" + this.autoLoad + ", showErrors=" + this.showErrors + "]";
    }

    public static final class DisplaySettingsChangeEvent {
        private final String changedSetting;

        DisplaySettingsChangeEvent(String changedSetting) {
            this.changedSetting = changedSetting;
        }

        public String getChangedSetting() {
            return this.changedSetting;
        }

        public String toString() {
            return "DisplaySettingsChangeEvent [changedSetting=" + this.changedSetting + "]";
        }
    }

    @FunctionalInterface
    public static interface DisplaySettingsChangeListener {
        public void displaySettingsChanged(DisplaySettingsChangeEvent var1);
    }
}

