/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ShowThumbnailAction
extends AbstractAction
implements Layer.LayerAction {
    private final transient GeoImageLayer layer;

    public ShowThumbnailAction(GeoImageLayer layer) {
        super(I18n.tr("Show thumbnails", new Object[0]));
        new ImageProvider("dialogs/geoimage/togglegit").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Show image thumbnails instead of icons.", new Object[0]));
        this.layer = layer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.layer.setUseThumbs(!this.layer.isUseThumbs());
    }

    private static boolean enabled(GeoImageLayer layer) {
        return !layer.getImageData().getImages().isEmpty();
    }

    @Override
    public Component createMenuComponent() {
        JCheckBoxMenuItem toggleItem = new JCheckBoxMenuItem(this);
        toggleItem.setEnabled(ShowThumbnailAction.enabled(this.layer));
        toggleItem.setState(this.layer.isUseThumbs());
        return toggleItem;
    }

    @Override
    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof GeoImageLayer;
    }
}

