/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.gui.history.TagTableCellRenderer;
import org.openstreetmap.josm.tools.Diff;
import org.openstreetmap.josm.tools.Utils;

class TwoColumnDiff {
    public List<Item> referenceDiff;
    public List<Item> currentDiff;
    private final Object[] reference;
    private final Object[] current;
    boolean referenceReversed;

    TwoColumnDiff(Object[] reference, Object ... current) {
        this.reference = Utils.copyArray(reference);
        this.current = Utils.copyArray(current);
        this.referenceDiff = new ArrayList<Item>();
        this.currentDiff = new ArrayList<Item>();
        this.diff();
    }

    private void diff() {
        Diff.Change script = new Diff(this.reference, this.current).diff2(false);
        Object[] referenceReversed = Utils.copyArray(this.reference);
        Collections.reverse(Arrays.asList(referenceReversed));
        Diff.Change scriptReversed = new Diff(referenceReversed, this.current).diff2(false);
        if (scriptReversed == null || script != null && scriptReversed.getTotalNumberOfChanges() < script.getTotalNumberOfChanges()) {
            this.referenceReversed = true;
            this.twoColumnDiffFromScript(scriptReversed, referenceReversed, this.current, true);
        } else {
            this.referenceReversed = false;
            this.twoColumnDiffFromScript(script, this.reference, this.current, false);
        }
    }

    private void twoColumnDiffFromScript(Diff.Change script, Object[] a, Object[] b, boolean reversed) {
        int ia = 0;
        int ib = 0;
        while (script != null) {
            int deleted = script.deleted;
            int inserted = script.inserted;
            while (ia < script.line0 && ib < script.line1) {
                this.referenceDiff.add(new Item(reversed ? Item.DiffItemType.REVERSED : Item.DiffItemType.SAME, a[ia++]));
                this.currentDiff.add(new Item(Item.DiffItemType.SAME, b[ib++]));
            }
            while (inserted > 0 || deleted > 0) {
                if (inserted > 0 && deleted > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.CHANGED, a[ia++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.CHANGED, b[ib++]));
                } else if (inserted > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                    this.currentDiff.add(new Item(Item.DiffItemType.INSERTED, b[ib++]));
                } else {
                    this.referenceDiff.add(new Item(Item.DiffItemType.DELETED, a[ia++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                }
                --inserted;
                --deleted;
            }
            script = script.link;
        }
        while (ia < a.length && ib < b.length) {
            this.referenceDiff.add(new Item(reversed ? Item.DiffItemType.REVERSED : Item.DiffItemType.SAME, a[ia++]));
            this.currentDiff.add(new Item(Item.DiffItemType.SAME, b[ib++]));
        }
    }

    public static class Item {
        public final Object value;
        public final DiffItemType state;

        Item(DiffItemType state, Object value) {
            this.state = state;
            this.value = state == DiffItemType.EMPTY ? null : value;
        }

        public static enum DiffItemType {
            INSERTED(new Color(221, 255, 221)),
            DELETED(new Color(255, 197, 197)),
            CHANGED(new Color(255, 234, 213)),
            REVERSED(new Color(255, 255, 204)),
            SAME(new Color(234, 234, 234)),
            EMPTY(new Color(234, 234, 234));

            private final Color color;

            private DiffItemType(Color color) {
                this.color = color;
            }

            public Color getColor() {
                return this.color;
            }

            public Color getColor(boolean isSelected, boolean hasFocus) {
                if (isSelected && hasFocus) {
                    return TagTableCellRenderer.BGCOLOR_SELECTED_FOCUS;
                }
                if (isSelected) {
                    return TagTableCellRenderer.BGCOLOR_SELECTED;
                }
                return this.getColor();
            }
        }
    }
}

