/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;

class DiffTableModel
extends AbstractTableModel {
    private transient List<TwoColumnDiff.Item> rows = new ArrayList<TwoColumnDiff.Item>();
    private transient int[] rowNumbers;
    private boolean reversed;

    DiffTableModel() {
    }

    public void setRows(List<TwoColumnDiff.Item> rows, boolean reversed) {
        this.rows = rows;
        this.reversed = reversed;
        this.computeRowNumbers();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public TwoColumnDiff.Item getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex);
    }

    public int getFirstChange() {
        return IntStream.range(0, this.rows.size()).filter(i -> this.rows.get((int)i).state != TwoColumnDiff.Item.DiffItemType.SAME).findFirst().orElse(-1);
    }

    void computeRowNumbers() {
        AtomicInteger rowNumber = new AtomicInteger(this.reversed ? this.rows.size() : 1);
        this.rowNumbers = this.rows.stream().mapToInt(item -> {
            if (item.state == TwoColumnDiff.Item.DiffItemType.EMPTY) {
                return -1;
            }
            if (this.reversed) {
                return rowNumber.getAndDecrement();
            }
            return rowNumber.getAndIncrement();
        }).toArray();
    }

    public int getRowNumber(int rowIndex) {
        return this.rowNumbers[rowIndex];
    }
}

