/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import javax.swing.RootPaneContainer;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SavingAction;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Utils;

public class CancelAction
extends SavingAction {
    private static final long serialVersionUID = 1L;

    public CancelAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, new IRelationEditorUpdateOn[0]);
        this.putValue("ShortDescription", I18n.tr("Cancel the updates and close the dialog", new Object[0]));
        new ImageProvider("cancel").getResource().attachImageIcon(this);
        this.putValue("Name", I18n.tr("Cancel", new Object[0]));
        if (this.getEditor() instanceof RootPaneContainer) {
            InputMapUtils.addEscapeAction(((RootPaneContainer)((Object)this.getEditor())).getRootPane(), this);
        }
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getMemberTable().stopHighlighting();
        Relation snapshot = this.getEditor().getRelationSnapshot();
        if (!(this.getMemberTableModel().hasSameMembersAs(snapshot) && !this.getTagModel().isDirty() || snapshot == null && this.getTagModel().getTags().isEmpty())) {
            int ret = this.confirmClosingByCancel(this.editorAccess.wouldRelationBeUseful());
            if (ret == 0) {
                Config.getPref().put("relation.editor.generic.lastrole", Utils.strip(this.tfRole.getText()));
                if (!this.applyChanges()) {
                    return;
                }
            } else if (ret == 2 || ret == -1) {
                return;
            }
        }
        this.hideEditor();
    }

    protected int confirmClosingByCancel(boolean isUseful) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, save the changes and close", new Object[0]), new ImageProvider("ok"), I18n.tr("Click to save the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, discard the changes and close", new Object[0]), new ImageProvider("undo"), I18n.tr("Click to discard the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel, continue editing", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
        options[0].setEnabled(isUseful);
        return HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("<html>The relation has been changed.<br><br>Do you want to save your changes?</html>", new Object[0]), I18n.tr("Unsaved changes", new Object[0]), 2, null, options, options[0], "/Dialog/RelationEditor#DiscardChanges");
    }
}

