/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;

public class MergedTableCellRenderer
extends TagMergeTableCellRenderer {
    protected void setBackgroundColor(TagMergeItem item, boolean isSelected) {
        if (isSelected) {
            this.setBackground(ConflictColors.BGCOLOR_SELECTED.get());
            return;
        }
        if (MergeDecisionType.KEEP_MINE == item.getMergeDecision()) {
            this.setBackground(ConflictColors.BGCOLOR_COMBINED.get());
        } else if (MergeDecisionType.KEEP_THEIR == item.getMergeDecision()) {
            this.setBackground(ConflictColors.BGCOLOR_COMBINED.get());
        } else if (MergeDecisionType.UNDECIDED == item.getMergeDecision()) {
            this.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
        }
    }

    @Override
    protected void renderKey(TagMergeItem item, boolean isSelected) {
        this.setBackgroundColor(item, isSelected);
        if (MergeDecisionType.KEEP_MINE == item.getMergeDecision() && item.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>", new Object[0]));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", item.getKey()));
        } else if (MergeDecisionType.KEEP_THEIR == item.getMergeDecision() && item.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>", new Object[0]));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", item.getKey()));
        } else if (MergeDecisionType.UNDECIDED == item.getMergeDecision()) {
            this.setText("");
        } else {
            this.setText(item.getKey());
            this.setToolTipText(item.getKey());
        }
    }

    @Override
    protected void renderValue(TagMergeItem item, boolean isSelected) {
        this.setBackgroundColor(item, isSelected);
        if (MergeDecisionType.KEEP_MINE == item.getMergeDecision() && item.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>", new Object[0]));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", item.getKey()));
        } else if (MergeDecisionType.KEEP_THEIR == item.getMergeDecision() && item.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>", new Object[0]));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", item.getKey()));
        } else if (MergeDecisionType.UNDECIDED == item.getMergeDecision()) {
            this.setText("");
        } else if (MergeDecisionType.KEEP_MINE == item.getMergeDecision()) {
            this.setText(item.getMyTagValue());
            this.setToolTipText(item.getMyTagValue());
        } else if (MergeDecisionType.KEEP_THEIR == item.getMergeDecision()) {
            this.setText(item.getTheirTagValue());
            this.setToolTipText(item.getTheirTagValue());
        }
    }
}

