/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.awt.BasicStroke;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.tools.Logging;

public class StrokeProperty
extends AbstractToStringProperty<BasicStroke> {
    public StrokeProperty(String key, String defaultValue) {
        super(key, StrokeProperty.getFromString(defaultValue));
    }

    public StrokeProperty(String key, BasicStroke defaultStroke) {
        super(key, defaultStroke);
    }

    @Override
    protected BasicStroke fromString(String string) {
        return StrokeProperty.getFromString(string);
    }

    @Override
    protected String toString(BasicStroke t) {
        StringBuilder string = new StringBuilder();
        string.append(t.getLineWidth());
        float[] dashes = t.getDashArray();
        if (dashes != null) {
            for (float d : dashes) {
                string.append(' ').append(d);
            }
        }
        return string.toString();
    }

    public static BasicStroke getFromString(String code) {
        int join;
        int cap;
        double sumAbs;
        Pattern floatPattern = Pattern.compile("(\\.\\d+|\\d+(\\.\\d+)?)");
        List captures = Pattern.compile("[^\\d.]+").splitAsStream(code).filter(s -> floatPattern.matcher((CharSequence)s).matches()).map(Double::valueOf).collect(Collectors.toList());
        double w = 1.0;
        List<Double> dashes = Collections.emptyList();
        if (!captures.isEmpty()) {
            w = (Double)captures.get(0);
            dashes = captures.subList(1, captures.size());
        }
        if (!dashes.isEmpty() && (sumAbs = dashes.stream().mapToDouble(Math::abs).sum()) < 0.1) {
            Logging.error("Error in stroke dash format (all zeros): " + code);
            dashes = Collections.emptyList();
        }
        if (w > 1.0) {
            cap = 1;
            join = 1;
        } else {
            cap = 0;
            join = 0;
        }
        return new BasicStroke((float)w, cap, join, 10.0f, StrokeProperty.toDashArray(dashes), 0.0f);
    }

    private static float[] toDashArray(List<Double> dashes) {
        if (dashes.isEmpty()) {
            return null;
        }
        float[] array = new float[dashes.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (float)dashes.get(i).doubleValue();
        }
        return array;
    }
}

