/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DialogsToggleAction
extends ToggleAction {
    private boolean toolbarPreviouslyVisible;
    private boolean sideToolbarPreviouslyVisible;

    public DialogsToggleAction() {
        super(I18n.tr("Dialogs panel", new Object[0]), new ImageProvider("dialogs/dialogs_panel"), I18n.tr("Toggle dialogs panel, maximize mapview", new Object[0]), Shortcut.registerShortcut("menu:view:dialogspanel", I18n.tr("View: {0}", I18n.tr("Dialogs panel", new Object[0])), 9, 5003), true, "dialogspanel", false);
        this.setHelpId(HelpUtil.ht("/ToggleDialogs"));
        this.setSelected(Config.getPref().getBoolean("draw.dialogspanel", true));
        this.notifySelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleSelectedState(e);
        Config.getPref().putBoolean("draw.dialogspanel", this.isSelected());
        this.notifySelectedState();
        this.setMode();
    }

    protected void setMode() {
        if (MainApplication.isDisplayingMapView()) {
            boolean selected = this.isSelected();
            if (!selected) {
                this.toolbarPreviouslyVisible = MapFrame.TOOLBAR_VISIBLE.get();
                this.sideToolbarPreviouslyVisible = MapFrame.SIDE_TOOLBAR_VISIBLE.get();
            }
            MapFrame map = MainApplication.getMap();
            map.setDialogsPanelVisible(selected);
            map.statusLine.setVisible(selected || Config.getPref().getBoolean("statusbar.always-visible", true));
            MainApplication.getMenu().setVisible(selected || Config.getPref().getBoolean("menu.always-visible", true));
            if (!(Config.getPref().getBoolean("toolbar.always-visible", true) || selected && !this.toolbarPreviouslyVisible)) {
                MapFrame.TOOLBAR_VISIBLE.put(selected);
            }
            if (!(Config.getPref().getBoolean("sidetoolbar.always-visible", true) || selected && !this.sideToolbarPreviouslyVisible)) {
                MapFrame.SIDE_TOOLBAR_VISIBLE.put(selected);
            }
            map.mapView.setMapNavigationComponentVisibility(selected || Config.getPref().getBoolean("navigation.always-visible", true));
            map.mapView.rememberLastPositionOnScreen();
        }
    }
}

